/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceIIFWithConstantConditionWithResultExpression
extends Transformation {
    public ReplaceIIFWithConstantConditionWithResultExpression(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace IIF With Same Result Expression";
        this.mTypes = new int[]{1085};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXComparisonOperator comparison = (MDXComparisonOperator)node.getChild(0);
        Object lhsValue = ((MDXNumericConstant)comparison.getChild(0)).getConstantValue();
        Object rhsValue = ((MDXNumericConstant)comparison.getChild(1)).getConstantValue();
        int result = 0;
        if (lhsValue instanceof Integer) {
            result = ((Integer)lhsValue).compareTo((Integer)rhsValue);
        } else if (lhsValue instanceof Double) {
            result = ((Double)lhsValue).compareTo((Double)rhsValue);
        } else {
            node.throwInternalError("Unexpected constant numeric type.");
        }
        IXQEQueryNode replacementNode = null;
        switch (comparison.getOperatorType()) {
            case 1: {
                if (result == 0) {
                    replacementNode = node.getChild(1);
                    break;
                }
                replacementNode = node.getChild(2);
                break;
            }
            case 6: {
                if (result >= 0) {
                    replacementNode = node.getChild(1);
                    break;
                }
                replacementNode = node.getChild(2);
                break;
            }
            case 3: {
                if (result > 0) {
                    replacementNode = node.getChild(1);
                    break;
                }
                replacementNode = node.getChild(2);
                break;
            }
            case 5: {
                if (result <= 0) {
                    replacementNode = node.getChild(1);
                    break;
                }
                replacementNode = node.getChild(2);
                break;
            }
            case 4: {
                if (result < 0) {
                    replacementNode = node.getChild(1);
                    break;
                }
                replacementNode = node.getChild(2);
                break;
            }
            case 2: {
                if (result != 0) {
                    replacementNode = node.getChild(1);
                    break;
                }
                replacementNode = node.getChild(2);
                break;
            }
            default: {
                node.throwInternalError("Unexpected numeric comparison type.");
            }
        }
        if (replacementNode.getParent() != null) {
            replacementNode.getParent().detachChild(replacementNode);
        }
        node.getParent().exchangeChildNode(node, replacementNode, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1070) {
            this.traceNodeCondition(false, "The first child of the target node is not a comparison operator.", trace);
            return false;
        }
        MDXComparisonOperator comparison = (MDXComparisonOperator)node.getChild(0);
        AbstractMDXNode lhsComparison = (AbstractMDXNode)comparison.getChild(0);
        AbstractMDXNode rhsComparison = (AbstractMDXNode)comparison.getChild(1);
        if (lhsComparison.getType() == 1064 && rhsComparison.getType() == 1064) {
            Object lhsValue = ((MDXNumericConstant)lhsComparison).getConstantValue();
            Object rhsValue = ((MDXNumericConstant)rhsComparison).getConstantValue();
            if (lhsValue.getClass() == rhsValue.getClass()) {
                this.traceNodeCondition(true, "The children of the comparison node of the target node are numeric constants of the same type.", trace);
                return true;
            }
        }
        this.traceNodeCondition(false, "The children of the comparison node of the target node are not numeric constants of the same type.", trace);
        return false;
    }
}

