/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class ReplaceIIFWithResultExpression
extends Transformation {
    public ReplaceIIFWithResultExpression(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace IIF With Same Result Expression";
        this.mTypes = new int[]{1085, 1086};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode valueExpr = node.detachChild(1);
        node.getParent().exchangeChildNode(node, valueExpr, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getDescendantsOfType(1004, false).length > 0) {
            this.traceNodeCondition(false, "The target node has a descendant which is a set alias definition.", trace);
            return false;
        }
        if (node.getChild(1).isSameExpression(node.getChild(2), false)) {
            this.traceNodeCondition(true, "The second and third operands of the target node are the same expression.", trace);
            return true;
        }
        if (node.getChild(0).hasDescendantOfType(1004, false)) {
            this.traceNodeCondition(false, "The condition of the IFF contains a set alias definition.", trace);
            return false;
        }
        this.traceNodeCondition(false, "The second and third operands of the target node are not the same expression.", trace);
        return false;
    }
}

