/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.summary.AbstractReplaceSummaryWithMember;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import java.util.ArrayList;
import java.util.List;

public final class ReplacePeriodsToDateFunctionWithOptimalSetOfMembers
extends AbstractReplaceSummaryWithMember {
    public ReplacePeriodsToDateFunctionWithOptimalSetOfMembers() {
        this.mName = "Replace Periodstodate Function With Set of Members.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1075};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        List<AbstractMDXMember> listAbstractMDXMembers = this.getOptimalPeriodsToDateMembers(node, environment);
        MDXSet set = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)nodeFactory, listAbstractMDXMembers.toArray(new AbstractMDXMember[0]));
        node.getParent().exchangeChildNode(node, set, false);
    }

    private List<AbstractMDXMember> getOptimalPeriodsToDateMembers(IXQEQueryNode node, PlanningEnvironment environment) {
        ROLAPCubeReservation reservation;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXLevel level = (AbstractMDXLevel)node.getChild(0);
        BaseMember member = (BaseMember)node.getChild(1);
        MDXHierInfo hierInfo = level.getHierarchyInfo();
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        ArrayList<BaseMember> listAbstractMDXMembers = null;
        String cubeUniqueName = hierarchy.getDimension().getCube().getUniqueName();
        ROLAPCube rolapCube = ROLAPCubeManager.getInstance().getCube(cubeUniqueName);
        if (rolapCube != null && (reservation = rolapCube.reserve()) != null) {
            IROLAPHierarchy rolapHier = (IROLAPHierarchy)rolapCube.getHierarchy(hierarchy.getName());
            if (rolapHier != null) {
                ILevel rolapLevel = rolapHier.getLevel(level.getLevel().getUniqueName());
                ILevel rolapMemberLevel = rolapHier.getLevel(member.getLevel().getUniqueName());
                IMember rolapMember = null;
                if (rolapMemberLevel != null) {
                    rolapMember = rolapMemberLevel.getMember(member.getUniqueName());
                }
                if (rolapLevel != null && rolapMember != null) {
                    List<IMember> listRolapMembers = rolapHier.getOptimalPeriodsToDateMembers(rolapLevel, rolapMember);
                    listAbstractMDXMembers = new ArrayList<BaseMember>();
                    for (int i = 0; i < listRolapMembers.size(); ++i) {
                        IMember m = listRolapMembers.get(i);
                        ILevel l = hierarchy.getLevel(m.getLevel().getIndex());
                        BaseMember bm = MDXBuilder.buildMDXBaseMemberExpr(nodeFactory, m.getUniqueName(), l);
                        listAbstractMDXMembers.add(bm);
                    }
                }
            }
            rolapCube.unreserve(reservation);
        }
        return listAbstractMDXMembers;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!ROLAPUtilities.isQueryROLAP(environment)) {
            this.traceNodeCondition(false, "PERIODSTODATE function is not in a ROLAP Query.", trace);
            return false;
        }
        this.traceQueryCondition(true, "PERIODSTODATE function in a ROLAP Query.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The node does not contain a member child node.", trace);
            return false;
        }
        if (node.getChild(1).getType() != 1067) {
            this.traceNodeCondition(false, "The node's member child node is not that of a base member.", trace);
            return false;
        }
        if (node.getParent().getType() != 1060) {
            this.traceNodeCondition(false, "The parent of the node is not of summary function.", trace);
            return false;
        }
        MDXSummaryFunction summaryFn = (MDXSummaryFunction)node.getParent();
        if (!this.queryCondition(summaryFn, environment, true)) {
            return false;
        }
        StringBuilder msgStr = new StringBuilder();
        if (!this.nodeCondition(summaryFn, msgStr, true)) {
            this.traceNodeCondition(false, msgStr.toString(), trace);
            return false;
        }
        if (this.getOptimalPeriodsToDateMembers(node, environment) == null) {
            this.traceNodeCondition(false, "Failed to find the replacement set of members.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The parent of the node is a summary function with additive aggregate types.", trace);
        return true;
    }
}

