/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class ReplaceTupleItemOnSetItemOnSetWithSingleMemberByMember
extends Transformation {
    public ReplaceTupleItemOnSetItemOnSetWithSingleMemberByMember() {
        this.mName = "Replace MDXTupleItem on MDXSetItem on MDXSet containing only a member/member expression by the member/member expression";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] mdxSet = node.getChild(0).getDescendantsOfType(1039, false);
        node.getParent().exchangeChildNode(node, mdxSet[0].getChild(0), false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXTupleItem node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1054) {
            this.traceNodeCondition(false, "The first operand of the MDXTupleItem node is not an MDXSetItem node.", trace);
            return false;
        }
        MDXNumericConstant value = (MDXNumericConstant)node.getChild(1);
        if (!value.getConstantValue().equals(0)) {
            this.traceNodeCondition(false, "The second operand of the target MDXTupleItem node is not an MDXNumericConstant equal to 0.", trace);
            return false;
        }
        IXQEQueryNode[] mdxSet = node.getChild(0).getChildrenOfType(1039);
        if (mdxSet == null || mdxSet.length == 0) {
            this.traceNodeCondition(false, "MDXSetItem does not contain an MDXSet.", trace);
            return false;
        }
        if (mdxSet[0].getNumberChildren() != 1 || !mdxSet[0].getChild(0).isOfCategory(1022)) {
            this.traceNodeCondition(false, "MDXSetItem does not contain an MDXSet with single member.", trace);
            return false;
        }
        value = (MDXNumericConstant)node.getChild(0).getChild(1);
        if (!value.getConstantValue().equals(0)) {
            this.traceNodeCondition(false, "The second operand of the MDXSetItem node is not an MDXNumericConstant equal to 0.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target MDXTupleItem node is on a MDXSetItem on a MDXSet containing only a member or member expression node.", trace);
        return true;
    }
}

