/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.calculations;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveCalcMemberRefBaseMember
extends Transformation {
    public static final String ALLOW_AUTO_EXISTS_IN_SLICER = "queryPlanning.AllowAutoexistsWithSlicer[@enabled]";

    public RemoveCalcMemberRefBaseMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Calc. Member referencing based member expanded in place.";
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode value = ((MDXCalculatedMemberReference)node).getDefinition().getChildren()[0];
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 1069 && (parent.getParent().getType() == 1059 || parent.getParent().getType() == 1008)) {
            for (IXQEQueryNode member : value.getChild(0).getChildren()) {
                IXQEQueryNode newMember = nodeFactory.deepCopyNode(member);
                parent.addChild(newMember);
            }
            node.detach();
            return;
        }
        IXQEQueryNode newMember = nodeFactory.deepCopyNode(value.getChild(0).getChild(0));
        parent.exchangeChildNode(node, newMember, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] memberDefinitionChildren = ((MDXCalculatedMemberReference)node).getDefinition().getChildren();
        int solveOrder = ((MDXCalculatedMemberReference)node).getDefinition().getSolveOrder();
        if (solveOrder == 0 && memberDefinitionChildren.length == 1) {
            IHierarchy memberHierarcy;
            IXQEQueryNode value = memberDefinitionChildren[0];
            if (value.getType() != 1059) {
                this.traceNodeCondition(false, "The CM is not about getting the value of a single member.", trace);
                return false;
            }
            IXQEQueryNode tuple = value.getChild(0);
            if (tuple.getType() != 1069 || tuple.getNumberChildren() == 0) {
                this.traceNodeCondition(false, "The CM is not about getting the value of a single member tuple.", trace);
                return false;
            }
            for (IXQEQueryNode member : tuple.getChildren()) {
                if (member.isOfCategory(1022) || member.getType() == 1013) continue;
                this.traceNodeCondition(false, "the CM is not refererecing a single member.", trace);
                return false;
            }
            IHierarchy cmHierarchy = ((MDXCalculatedMemberReference)node).getHierarchy();
            if (tuple.getNumberChildren() == 1 && cmHierarchy != (memberHierarcy = ((AbstractMDXMember)tuple.getChild(0)).getHierarchy())) {
                this.traceNodeCondition(false, "The CM and the member are not from the same hierarchy.", trace);
                return false;
            }
            if (cmHierarchy.getDimension().isMeasuresDimension()) {
                this.traceNodeCondition(false, "The CM is over the measure dimension, we cannot remove it.", trace);
                return false;
            }
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            if (mdxQuery == null) {
                this.traceNodeCondition(false, "The query is not an MDX query.", trace);
                return false;
            }
            boolean allowAutoExistsInSlicer = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty(ALLOW_AUTO_EXISTS_IN_SLICER, false);
            if (mdxQuery.isYukonProvider() && !allowAutoExistsInSlicer && node.getAncestorOfType(1008) != null && mdxQuery.getReferencedMultipleHierarchies().contains(cmHierarchy)) {
                this.traceNodeCondition(false, "YK test case. The CM is referenced by the dimension line and there is multiple projected hierarchies from the same dimension.", trace);
                return false;
            }
            if (mdxQuery.isProjectedDescendant((MDXCalculatedMemberReference)node)) {
                this.traceNodeCondition(false, "The CM is projected on the edge, we need the CM for local processing of the result.", trace);
                return false;
            }
            IXQEQueryNode parent = node.getParent();
            if (parent.getType() == 1069 && (parent.getParent().getType() == 1059 || parent.getParent().getType() == 1008)) {
                MDXHierInfo tupleHierInfo = ((MDXTuple)tuple).getHierarchyInfo();
                MDXHierInfo parentNodeTupleHierInfo = ((MDXTuple)node.getParent()).getHierarchyInfo();
                parentNodeTupleHierInfo.removeProjectedHierarchy(cmHierarchy);
                if (parentNodeTupleHierInfo.projectedHierarchiesOverlap(tupleHierInfo)) {
                    return false;
                }
            } else if (parent.getType() == 1039 && parent.getNumberChildren() == 1) {
                parent = parent.getParent();
                while (parent.getType() == 1030) {
                    parent = parent.getParent();
                }
                if (parent.getType() != 1008) {
                    return false;
                }
                MDXHierInfo tupleHierInfo = ((MDXTuple)tuple).getHierarchyInfo();
                MDXHierInfo parentNodeTupleHierInfo = ((MDXDimensionLine)parent).getHierarchyInfo();
                parentNodeTupleHierInfo.removeProjectedHierarchy(cmHierarchy);
                if (parentNodeTupleHierInfo.projectedHierarchiesOverlap(tupleHierInfo)) {
                    return false;
                }
            } else {
                return false;
            }
            status = true;
            this.traceNodeCondition(status, "Reference calc. member defined by a simple base member.", trace);
        }
        if (!status) {
            this.traceNodeCondition(status, "Calc. member reference an expression.", trace);
        }
        return status;
    }
}

