/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.calculations;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;
import java.util.List;

public final class RemoveDuplicateCalculatedMemberDefinitions
extends Transformation {
    public RemoveDuplicateCalculatedMemberDefinitions(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Removes duplicate calculated member defintions.";
        this.mTypes = new int[]{1005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] setAliasReferences;
        IXQEQueryNode[] nestedCalcRefs;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        String dataSource = mdxQuery.getDataSourceType();
        MDXCalculatedMemberDefinition[] cmDefs = mdxQuery.getCalcMemberDefinitions();
        MDXCalculatedMemberDefinition thisDef = (MDXCalculatedMemberDefinition)node;
        for (int i = 0; i < cmDefs.length; ++i) {
            IXQEQueryNode[] compareDef = cmDefs[i];
            if (thisDef == compareDef || thisDef.getSolveOrder() != compareDef.getSolveOrder() || thisDef.isTag() || compareDef.isTag() || thisDef.getHierarchy() != compareDef.getHierarchy() || !thisDef.getChild(0).isSameExpression(compareDef.getChild(0), false) || DataSourceTypeEnum.isROLAP(dataSource) && !thisDef.getPrefix().equals(compareDef.getPrefix())) continue;
            List<MDXCalculatedMemberReference> cmRefs = thisDef.getCalcMemberRefs();
            for (MDXCalculatedMemberReference cmRef : cmRefs) {
                cmRef.bind((MDXCalculatedMemberDefinition)compareDef);
            }
            break;
        }
        for (IXQEQueryNode nestedCalcRef : nestedCalcRefs = thisDef.getDescendantsOfType(1013, false)) {
            ((MDXCalculatedMemberReference)nestedCalcRef).getDefinition().getCalcMemberRefs().remove(nestedCalcRef);
        }
        for (IXQEQueryNode setAliasReference : setAliasReferences = thisDef.getDescendantsOfType(1015, false)) {
            ((MDXSetAliasReference)setAliasReference).getDefinition().getSetAliasRefs().remove(setAliasReference);
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node;
        List<MDXCalculatedMemberReference> calcRef = calcDef.getCalcMemberRefs();
        for (MDXCalculatedMemberReference cmRef : calcRef) {
            if (cmRef.getDefinition().isFillerTag()) {
                this.traceQueryCondition(false, "The target MDXCalculatedMemberDefinition node is a tag.", trace);
                return false;
            }
            MDXEdge mdxEdge = (MDXEdge)cmRef.getAncestorOfType(1006);
            if (mdxEdge == null || !mdxEdge.isProjectedDescendant(cmRef)) continue;
            this.traceQueryCondition(false, "The target MDXCalculatedMemberDefinition node is projected.", trace);
            return false;
        }
        String dataSource = mdxQuery.getDataSourceType();
        MDXCalculatedMemberDefinition[] cmDefs = mdxQuery.getCalcMemberDefinitions();
        MDXCalculatedMemberDefinition thisDef = (MDXCalculatedMemberDefinition)node;
        for (int i = 0; i < cmDefs.length; ++i) {
            MDXCalculatedMemberDefinition compareDef = cmDefs[i];
            if (thisDef == compareDef || thisDef.getSolveOrder() != compareDef.getSolveOrder() || thisDef.isTag() || compareDef.isTag() || thisDef.getHierarchy() != compareDef.getHierarchy() || !thisDef.getChild(0).isSameExpression(compareDef.getChild(0), false) || DataSourceTypeEnum.isROLAP(dataSource) && !thisDef.getPrefix().equals(compareDef.getPrefix())) continue;
            this.traceQueryCondition(true, "The target MDXCalculatedMemberDefinition node is a duplicate of another.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The target MDXCalculatedMemberDefinition node is not a duplicate of another.", trace);
        return false;
    }
}

