/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.calculations;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveUnReferencedCalculatedMember
extends Transformation {
    public RemoveUnReferencedCalculatedMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Remove an unreferenced calculated member definition.";
        this.mTypes = new int[]{1005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detach();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode cogMDXQueryNode = node.getParent();
        if (cogMDXQueryNode.getType() == 1002) {
            status = true;
            this.traceQueryCondition(status, "We are within a MDQuery", trace);
        } else {
            this.traceQueryCondition(status, "We are not within a MDQuery.", trace);
        }
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        MDXQuery mdQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!mdQuery.isDefinitionReferenced((MDXCalculatedMemberDefinition)node)) {
            status = true;
            this.traceNodeCondition(status, "Calc. Member is not referenced within the query.", trace);
        }
        if (!status) {
            this.traceNodeCondition(status, "Calc. Member is referenced within the query.", trace);
        }
        return status;
    }
}

