/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.generate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeGenerateOnLevelWithIntersect
extends Transformation {
    public OptimizeGenerateOnLevelWithIntersect(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace GENERATE( Level1.MEMBERS, INTERSECT ( CURRENTMEMBER, ... ) ) by INTERSECT( Level1.MEMBBERS , ... ).";
        this.mTypes = new int[]{1057};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode allMembersOfALevel = node.detachChild(0);
        IXQEQueryNode intersect = node.detachChild(0);
        intersect.exchangeChildNode(intersect.getChild(0), allMembersOfALevel, false);
        node.getParent().exchangeChildNode(node, intersect, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 2) {
            IHierarchy hierarchy;
            IHierarchy memberHierarchy;
            IXQEQueryNode currentMemberHierarchy;
            IXQEQueryNode currentMember;
            IXQEQueryNode currentMemberSet;
            IXQEQueryNode membersLevel;
            IXQEQueryNode firstChild = node.getChild(0);
            IXQEQueryNode secondChild = node.getChild(1);
            boolean isValidSetFunction = true;
            while (firstChild.getType() != 1040 && isValidSetFunction) {
                if (firstChild.getType() != 1058) {
                    isValidSetFunction = false;
                    continue;
                }
                firstChild = firstChild.getChild(0);
            }
            if (firstChild.getType() == 1040 && (membersLevel = firstChild.getChild(0)).isOfCategory(1023) && secondChild.getType() == 1038 && secondChild.getNumberChildren() == 2 && (currentMemberSet = secondChild.getChild(0)).getType() == 1039 && (currentMember = currentMemberSet.getChild(0)).getType() == 1076 && currentMember.getNumberChildren() == 1 && (currentMemberHierarchy = currentMember.getChild(0)).isOfCategory(1072) && (memberHierarchy = ((AbstractMDXLevel)membersLevel).getLevel().getHierarchy()).equals(hierarchy = ((AbstractMDXHierarchy)currentMemberHierarchy).getHierarchy())) {
                status = true;
                this.traceNodeCondition(status, "Generate the Intersect of the current member for all members of a level.", trace);
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "The expression is not a valid one to optimize.", trace);
        }
        return status;
    }
}

