/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeDoubleIntersectOnSameRootSet
extends Transformation {
    public OptimizeDoubleIntersectOnSameRootSet(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace MDX INTERSECT when applied on the same intial set 2 consecutive times.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detachSecondChild();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] children = node.getChildren();
        if (children.length == 2) {
            IXQEQueryNode[] firstChildChildren;
            IXQEQueryNode firstChild = children[0];
            IXQEQueryNode secondChild = children[1];
            if (secondChild.isOfCategory(1021) && firstChild.getType() == 1038 && (firstChildChildren = firstChild.getChildren()).length == 2) {
                IXQEQueryNode childfirstChild = firstChildChildren[0];
                IXQEQueryNode childsecondChild = firstChildChildren[1];
                if (childfirstChild.isOfCategory(1021) && childsecondChild.isOfCategory(1021) && (secondChild.isSameExpression(childsecondChild, false) || secondChild.isSameExpression(childfirstChild, false))) {
                    status = true;
                    this.traceNodeCondition(status, "Both involved set are the same.", trace);
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "Expression differ.", trace);
        }
        return status;
    }
}

