/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectFilteredLevelWithDescendantsOfMember
extends Transformation {
    public OptimizeIntersectFilteredLevelWithDescendantsOfMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Intersect Filtered Level With Descendants Of Member";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode mdxFilter = node.getChild(0);
        MDXDescendants mdxDescendants = (MDXDescendants)node.detachChild(1);
        node.extract();
        if (mdxFilter.getChild(0).getChild(0).isOfCategory(1023)) {
            mdxDescendants.setRangeFlag(0);
        }
        mdxFilter.exchangeChildNode(mdxFilter.getChild(0), mdxDescendants, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXIntersect node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1053) {
            this.traceNodeCondition(false, "The first operand of the MDXIntersect node is not an MDXFilter node.", trace);
            return false;
        }
        MDXFilter mdxFilter = (MDXFilter)node.getChild(0);
        if (!mdxFilter.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXFilter node are invalid.", trace);
            return false;
        }
        if (mdxFilter.getChild(0).getType() != 1040) {
            this.traceNodeCondition(false, "The first operand of the MDXFilter node is not an MDXMembers node.", trace);
            return false;
        }
        MDXMembers mdxMembers = (MDXMembers)mdxFilter.getChild(0);
        if (!mdxMembers.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXMembers node are invalid.", trace);
            return false;
        }
        if (node.getChild(1).getType() != 1052) {
            this.traceNodeCondition(false, "The second operand of the MDXIntersect node is not an MDXDescendants node.", trace);
            return false;
        }
        MDXDescendants mdxDescendants = (MDXDescendants)node.getChild(1);
        if (!mdxDescendants.getChild(0).isOfCategory(1022)) {
            this.traceNodeCondition(false, "The first operand of the MDXDescendants node is not a member expression.", trace);
            return false;
        }
        IHierarchy hierarchy = null;
        ILevel level = null;
        if (mdxMembers.getChild(0).isOfCategory(1023)) {
            MDXLevelInfo levelInfo = mdxMembers.getLevelInfo();
            if (levelInfo.getNumProjectedLevels(hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0)) != 1) {
                this.traceNodeCondition(false, "The MDXMembers expression does not project a single level.", trace);
                return false;
            }
            level = levelInfo.getProjectedLevel(hierarchy, 0);
        } else {
            hierarchy = mdxMembers.getHierarchyInfo().getProjectedHierarchy(0);
        }
        if (level != null) {
            AbstractMDXMember memberOperand = (AbstractMDXMember)mdxDescendants.getChild(0);
            if (!memberOperand.getHierarchyInfo().getProjectedHierarchy(0).equals(hierarchy)) {
                this.traceNodeCondition(false, "The first operand of the MDXDescendants expression does not project the same hierarchy as the MDXMembers expression.", trace);
            }
            if (!mdxDescendants.getChild(1).isOfCategory(1023)) {
                this.traceNodeCondition(false, "The first operand of the MDXDescendants node is not a level expression.", trace);
                return false;
            }
            if (mdxDescendants.getRangeFlag() != 0 && mdxDescendants.getRangeFlag() != 5 && mdxDescendants.getRangeFlag() != 4 && mdxDescendants.getRangeFlag() != 6) {
                this.traceNodeCondition(false, "The range flag on the MDXDescendants node is not SELF, SELF_AND_BEFORE, SELF_AND_AFTER, or SELF_BEFORE_AFTER.", trace);
                return false;
            }
            MDXLevelInfo levelInfo = ((AbstractMDXLevel)mdxDescendants.getChild(1)).getLevelInfo();
            if (levelInfo.getNumProjectedLevels(hierarchy) != 1 || levelInfo.getProjectedLevel(hierarchy, 0).compareTo(level) != 0) {
                this.traceNodeCondition(false, "The second operand of the MDXDescendants node does not project the same single level as the MDXMembers expression.", trace);
                return false;
            }
        } else if (!mdxDescendants.getHierarchyInfo().getProjectedHierarchy(0).equals(hierarchy)) {
            this.traceNodeCondition(false, "The MDXDescendants expression does not project the same hierarchy as the MDXMembers expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The expression can be optimized.", trace);
        return true;
    }
}

