/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectLevelWithDescendantsOnSingleMember
extends Transformation {
    public OptimizeIntersectLevelWithDescendantsOnSingleMember(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace INTERSECT( Level1.MEMBERS, DESCENDANTS( member1, Level1 ) ) by DESCENDANTS( member1, Level1 )";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode descendants = node.getChild(1);
        node.getParent().exchangeChildNode(node, descendants, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (node.getNumberChildren() == 2) {
            IXQEQueryNode members = node.getChild(0);
            IXQEQueryNode descendant = node.getChild(1);
            if (members.getType() == 1040 && members.getNumberChildren() == 1 && descendant.getType() == 1052) {
                ILevel descendantsLevel;
                ILevel intersectLevel;
                IXQEQueryNode descendantBaseLevel;
                IXQEQueryNode baseLevel = members.getChild(0);
                if (((MDXDescendants)descendant).getRangeFlag() == 0 && baseLevel.getType() == 1065 && descendant.getNumberChildren() == 2 && (descendantBaseLevel = descendant.getChild(1)).getType() == 1065 && (intersectLevel = ((BaseLevel)baseLevel).getLevel()).compareTo(descendantsLevel = ((BaseLevel)descendantBaseLevel).getLevel()) == 0) {
                    status = true;
                    this.traceNodeCondition(status, "Intersect a level with the descendant of a member to this level...", trace);
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "The expression is not a valid one to optimize.", trace);
        }
        return status;
    }
}

