/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectLevelWithHierarchy
extends Transformation {
    public OptimizeIntersectLevelWithHierarchy(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Intersect Level With Hierarchy.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXMembers mdxMemberOnLevel = (MDXMembers)node.getChild(0);
        if (mdxMemberOnLevel.getChild(0).getType() != 1065) {
            mdxMemberOnLevel = (MDXMembers)node.getChild(1);
        }
        node.detachChild(mdxMemberOnLevel);
        node.getParent().exchangeChildNode(node, mdxMemberOnLevel, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXHierInfo op2HierInfo;
        XQETrace trace = environment.getTrace();
        if (!((MDXIntersect)node).validateChildCategories()) {
            this.traceNodeCondition(false, "The MDXIntersect node is invalid.", trace);
            return false;
        }
        IXQEQueryNode[] mdxMembersOps = node.getChildrenOfType(1040);
        if (mdxMembersOps.length != 2) {
            this.traceNodeCondition(false, "At least one of the operands is not an MDXMembers expression.", trace);
            return false;
        }
        MDXHierInfo op1HierInfo = ((MDXMembers)node.getChild(0)).getHierarchyInfo();
        if (!op1HierInfo.compareProjectedHierarchies(op2HierInfo = ((MDXMembers)node.getChild(1)).getHierarchyInfo())) {
            this.traceNodeCondition(false, "The operands project different hierarchies.", trace);
            return false;
        }
        MDXMembers mdxMemberOnLevel = (MDXMembers)node.getChild(0);
        MDXMembers mdxMemberOnHierarchy = (MDXMembers)node.getChild(1);
        if (mdxMemberOnLevel.getChild(0).getType() != 1065) {
            mdxMemberOnLevel = (MDXMembers)node.getChild(1);
            mdxMemberOnHierarchy = (MDXMembers)node.getChild(0);
            if (mdxMemberOnLevel.getChild(0).getType() != 1065) {
                this.traceNodeCondition(false, "Neither of the operands is an MDXMember expression on a BaseLevel.", trace);
                return false;
            }
            if (mdxMemberOnHierarchy.getChild(0).getType() != 1073) {
                this.traceNodeCondition(false, "Neither of the operands is an MDXMember expression on a BaseHierarchy.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "The MDXIntersect node has an MDXMember expression on a level and an MDXMember expression on a hierarchy as operands.", trace);
        return true;
    }
}

