/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectLevelWithIntersect
extends Transformation {
    public OptimizeIntersectLevelWithIntersect(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Intersect Level With Intersect.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXMembers mdxMembers = (MDXMembers)node.getFirstChildByType(1040);
        mdxMembers.detach();
        MDXIntersect mdxIntersect = (MDXIntersect)node.getFirstChildByType(1038);
        mdxIntersect.setAll(false);
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXLevelInfo intersectLevelInfo;
        XQETrace trace = environment.getTrace();
        if (!((MDXIntersect)node).validateChildCategories()) {
            this.traceNodeCondition(false, "The MDXIntersect node is invalid.", trace);
            return false;
        }
        MDXMembers mdxMembers = (MDXMembers)node.getFirstChildByType(1040);
        if (mdxMembers == null || mdxMembers.getChild(0).getType() != 1065) {
            this.traceNodeCondition(false, "The MDXIntersect node does not have an operand which is MDXMembers on a BaseLevel.", trace);
            return false;
        }
        MDXIntersect mdxIntersect = (MDXIntersect)node.getFirstChildByType(1038);
        if (mdxIntersect == null) {
            this.traceNodeCondition(false, "The MDXIntersect node does not have an operand which is an MDXIntersect node.", trace);
            return false;
        }
        MDXLevelInfo membersLevelInfo = mdxMembers.getLevelInfo();
        if (!membersLevelInfo.compareProjectedLevels(intersectLevelInfo = mdxIntersect.getLevelInfo())) {
            this.traceNodeCondition(false, "The levels projected by the MDXMembers and MDXIntersect operands do not match.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The levels projected by the MDXMembers and MDXIntersect match.", trace);
        return true;
    }
}

