/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXExcept;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectOnExcept
extends Transformation {
    public OptimizeIntersectOnExcept(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Intersect On Except.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXExcept mdxExcept = (MDXExcept)node.getFirstChildByType(1032);
        boolean useAll = false;
        if (((AbstractMDXSet)node.getChild(0)).projectsDuplicates() && ((MDXIntersect)node).getAll()) {
            useAll = true;
        }
        mdxExcept.setAll(useAll);
        IXQEQueryNode exceptFirstChild = mdxExcept.detachChild(0);
        node.exchangeChildNode(mdxExcept, exceptFirstChild, false);
        node.getParent().exchangeChildNode(node, mdxExcept, false);
        mdxExcept.addChild(node, 0);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXMembers mdxMembers;
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXIntersect node are invalid.", trace);
            return false;
        }
        IXQEQueryNode excludeChild = node.getChild(0);
        IXQEQueryNode otherChild = node.getChild(1);
        if (node.getChild(1).getType() == 1032) {
            IXQEQueryNode tempChild = excludeChild;
            excludeChild = otherChild;
            otherChild = tempChild;
        }
        if (excludeChild.getType() != 1032) {
            this.traceNodeCondition(false, "No operand of the MDXIntersect node is a MDXExcept node.", trace);
            return false;
        }
        if (!excludeChild.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXExcept node are invalid.", trace);
            return false;
        }
        if (otherChild.isSameExpression(excludeChild.getChild(0), false)) {
            this.traceNodeCondition(true, "The first child of the MDXExcept node is same with the other child from the MDXIntersect node.", trace);
            return true;
        }
        if (excludeChild.getChild(0).getType() == 1040) {
            mdxMembers = (MDXMembers)excludeChild.getChild(0);
        } else if (otherChild.getType() == 1040) {
            mdxMembers = (MDXMembers)otherChild;
            otherChild = excludeChild.getChild(0);
        } else {
            this.traceNodeCondition(false, "The first operand of the MDXExcept node or the other operand ofthe MDXIntersect node is not a MDXMembers node.", trace);
            return false;
        }
        if (mdxMembers.getChild(0).isOfCategory(1072)) {
            MDXHierInfo set2HierInfo;
            MDXHierInfo set1HierInfo = ((AbstractMDXSet)otherChild).getHierarchyInfo();
            if (!set1HierInfo.compareProjectedHierarchies(set2HierInfo = mdxMembers.getHierarchyInfo())) {
                this.traceNodeCondition(false, "The first operand of the MDXExcept node and the other operand ofthe MDXIntersect node do not project that same single hierarchy.", trace);
                return false;
            }
        } else {
            MDXLevelInfo set2LevelInfo;
            MDXLevelInfo set1LevelInfo = ((AbstractMDXSet)otherChild).getLevelInfo();
            if (!set1LevelInfo.compareProjectedLevels(set2LevelInfo = mdxMembers.getLevelInfo())) {
                this.traceNodeCondition(false, "The first operand of the MDXExcept node and the other operand of the MDXIntersect node do not project that same single level.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, "The first child of the MDXExcept node or the other child of the MDXIntersect node is a MDXMembers node and both project the same single hierarchy or level.", trace);
        return true;
    }
}

