/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;
import java.util.ArrayList;

public final class OptimizeIntersectOnListOfMembers
extends Transformation {
    public OptimizeIntersectOnListOfMembers(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace MDX INTERSECT of a level with a list of member by Hierarchize on the list.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IXQEQueryNode[] children = node.getChildren();
        IXQEQueryNode secondChild = children[1];
        IXQEQueryNode firstChild = children[0];
        IXQEQueryNode baseMetaObject = firstChild.getChildren()[0];
        IXQEQueryNode[] allBaseMembers = secondChild.getChildren();
        BaseMember baseMember = null;
        ArrayList<String> addedMembers = new ArrayList<String>();
        String mun = null;
        for (int idx = 0; idx < allBaseMembers.length; ++idx) {
            MDXLevelInfo baseMemberLevelInfo;
            baseMember = (BaseMember)allBaseMembers[idx];
            mun = baseMember.getExternalName();
            boolean found = false;
            for (int idxName = 0; idxName < addedMembers.size(); ++idxName) {
                if (mun.compareTo((String)addedMembers.get(idxName)) != 0) continue;
                found = true;
                break;
            }
            if (found) {
                secondChild.detachChild(baseMember);
                continue;
            }
            MDXLevelInfo baseMetaObjectInfo = ((AbstractMDXNode)baseMetaObject).getLevelInfo();
            if (!baseMetaObjectInfo.projectedLevelsOverlap(baseMemberLevelInfo = baseMember.getLevelInfo())) {
                secondChild.detachChild(baseMember);
                continue;
            }
            addedMembers.add(baseMember.getExternalName());
        }
        secondChild = children[1];
        IXQEQueryNode mdxHierarchizeNode = nodeFactory.createNode(1037);
        node.detachChild(secondChild);
        mdxHierarchizeNode.addChild(secondChild);
        node.getParent().exchangeChildNode(node, mdxHierarchizeNode, false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] children = node.getChildren();
        if (children.length == 2) {
            IXQEQueryNode baseLevel;
            IXQEQueryNode firstChild = children[0];
            IXQEQueryNode secondChild = children[1];
            if (firstChild.getType() == 1040 && secondChild.getType() == 1039 && ((baseLevel = firstChild.getChildren()[0]).isOfCategory(1023) || baseLevel.isOfCategory(1072))) {
                IXQEQueryNode[] baseMembers = secondChild.getChildren();
                MDXLevelInfo levelInfo = ((MDXIntersect)node).getLevelInfo();
                if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() == 1 && !levelInfo.isEmpty()) {
                    status = true;
                    for (int idx = 0; idx < baseMembers.length && status; ++idx) {
                        if (baseMembers[idx].getType() == 1067) continue;
                        status = false;
                    }
                }
            }
        }
        if (status) {
            this.traceNodeCondition(status, "INTERSECT members from a level with a base member on this level.", trace);
        } else {
            this.traceNodeCondition(status, "Do not INTERSECT members from a level with a base member on this level.", trace);
        }
        return status;
    }
}

