/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectOnSameExpression
extends Transformation {
    public OptimizeIntersectOnSameExpression(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize MDXIntersect when the both sets are the same expression.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean useDistinct = false;
        if (!((MDXIntersect)node).getAll() && ((AbstractMDXSet)node.getChild(0)).projectsDuplicates()) {
            useDistinct = true;
        }
        node.detachSecondChild();
        if (useDistinct) {
            node.getChild(0).insertParent(factory.createNode(1033));
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXIntersect node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).isSameExpression(node.getChild(1), false)) {
            this.traceNodeCondition(true, "The MDXIntersect operands are the same expression.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The MDXIntersect operands are not the same expression.", trace);
        return false;
    }
}

