/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeIntersectOnTwoListOfMembers
extends Transformation {
    public OptimizeIntersectOnTwoListOfMembers(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Replace MDX INTERSECT of 2 list of members by the final list of members.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode firstSet = node.getChild(0);
        IXQEQueryNode[] baseMembersFirstSet = firstSet.getChildren();
        IXQEQueryNode[] baseMembersSecondSet = node.getChild(1).getChildren();
        BaseMember baseMember = null;
        String mun = null;
        for (int idx = 0; idx < baseMembersFirstSet.length; ++idx) {
            baseMember = (BaseMember)baseMembersFirstSet[idx];
            mun = baseMember.getExternalName();
            boolean found = false;
            for (int idxName = 0; idxName < baseMembersSecondSet.length; ++idxName) {
                if (mun.compareTo(((BaseMember)baseMembersSecondSet[idxName]).getExternalName()) != 0) continue;
                found = true;
                break;
            }
            if (found) continue;
            firstSet.detachChild(baseMembersFirstSet[idx]);
        }
        if (firstSet.getNumberChildren() == 0) {
            XQENodeFactory factory = environment.getNodeFactory();
            AbstractMDXSet emptySet = MDXBuilder.buildEmptySet(factory, (AbstractMDXSet)node.getChild(1));
            node.getParent().exchangeChildNode(node, emptySet, false);
        } else {
            node.detachChild(node.getChild(1));
            node.extract();
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IXQEQueryNode[] children = node.getChildren();
        if (children.length == 2) {
            IXQEQueryNode firstChild = children[0];
            IXQEQueryNode secondChild = children[1];
            if (firstChild.getType() == 1039 && secondChild.getType() == 1039 && ((MDXSet)firstChild).isListOfNonDuplicatedBaseMembers() && ((MDXSet)secondChild).isListOfBaseMembers()) {
                MDXHierInfo mdxSet1HierInfo = ((MDXSet)firstChild).getHierarchyInfo();
                MDXHierInfo mdxSet2HierInfo = ((MDXSet)secondChild).getHierarchyInfo();
                if (mdxSet1HierInfo.getNumProjectedHierarchies() == 1 && mdxSet1HierInfo.compareProjectedHierarchies(mdxSet2HierInfo)) {
                    status = true;
                    this.traceNodeCondition(status, "INTERSECT two list of members.", trace);
                }
            }
        }
        if (!status) {
            this.traceNodeCondition(status, "Do not INTERSECT two valid list of members.", trace);
        }
        return status;
    }
}

