/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class OptimizeRedundantIntersect
extends Transformation {
    public OptimizeRedundantIntersect(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Optimize Redundant Intersect";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode innerMDXIntersect = node.getChild(1);
        int otherChildPosition = 0;
        if (node.getChild(0).isSameExpression(innerMDXIntersect.getChild(0), false)) {
            otherChildPosition = 1;
        }
        IXQEQueryNode otherChild = innerMDXIntersect.detachChild(otherChildPosition);
        node.exchangeChildNode(innerMDXIntersect, otherChild);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the target MDXIntersect node are invalid.", trace);
            return false;
        }
        if (node.getChild(1).getType() != 1038) {
            this.traceNodeCondition(false, "The second child of the target MDXIntersect node is not an MDXIntersect node.", trace);
            return false;
        }
        if (!node.getChild(1).validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the inner MDXIntersect node are invalid.", trace);
            return false;
        }
        if (!node.getChild(0).isSameExpression(node.getChild(1).getChild(0), false) && !node.getChild(0).isSameExpression(node.getChild(1).getChild(1), false)) {
            this.traceNodeCondition(false, "The first child of the target MDXIntersect node and a child of the inner MDXIntersect node are not the same expression.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The first child of the target MDXIntersect node and a child of the inner MDXIntersect node are the same expression.", trace);
        return true;
    }
}

