/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.intersect;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveIntersectWithEntireHierarchy
extends Transformation {
    public RemoveIntersectWithEntireHierarchy(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Drop the MDX Intersect when not discarding any members.";
        this.mTypes = new int[]{1038};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.detachSecondChild();
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (((MDXIntersect)node).getAll()) {
            IXQEQueryNode hierarchyExpression;
            AbstractMDXSet setToFilter = (AbstractMDXSet)node.getChild(0);
            AbstractMDXSet setFilteredWith = (AbstractMDXSet)node.getChild(1);
            MDXHierInfo setToFilterInfo = setToFilter.getHierarchyInfo();
            MDXHierInfo setFilteredWithInfo = setFilteredWith.getHierarchyInfo();
            if (setToFilterInfo.getNumProjectedHierarchies() == 1 && setFilteredWithInfo.getNumProjectedHierarchies() == 1 && setToFilterInfo.compareProjectedHierarchies(setFilteredWithInfo) && setFilteredWith.getType() == 1040 && (hierarchyExpression = setFilteredWith.getChild(0)).isOfCategory(1072)) {
                status = true;
            }
        }
        if (status) {
            this.traceNodeCondition(status, "The MDX Intersect expression is matching the input pattern.", trace);
        } else {
            this.traceNodeCondition(status, "The MDX Intersect expression is not matching the input pattern.", trace);
        }
        return status;
    }
}

