/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.namedsets;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveDuplicateNamedSetDefinitions
extends Transformation {
    public RemoveDuplicateNamedSetDefinitions() {
        this.mName = "Remove Duplicate Named Set Definitions.";
        this.mTypes = new int[]{1003};
        this.mPassNumbers = new int[]{46};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] nsDefs = mdxQuery.getChildrenOfType(1003);
        for (int i = 0; i < nsDefs.length; ++i) {
            MDXNamedSetDefinition dupNSDef = (MDXNamedSetDefinition)nsDefs[i];
            if (dupNSDef == node || !dupNSDef.validateChildCategories() || !dupNSDef.getChild(0).isSameExpression(node.getChild(0), false)) continue;
            IXQEQueryNode[] nsRefs = mdxQuery.getDescendantsOfType(1014, false);
            for (int j = 0; j < nsRefs.length; ++j) {
                MDXNamedSetReference nsRef = (MDXNamedSetReference)nsRefs[j];
                if (nsRef.getDefinition() != node) continue;
                nsRef.bind(dupNSDef);
            }
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.isValidPlannedQuery() != -1) {
            this.traceNodeCondition(false, "The target node expression is not a valid MDX expression.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] nsDefs = mdxQuery.getChildrenOfType(1003);
        for (int i = 0; i < nsDefs.length; ++i) {
            if (nsDefs[i] == node || !nsDefs[i].validateChildCategories() || !nsDefs[i].getChild(0).isSameExpression(node.getChild(0), false)) continue;
            this.traceQueryCondition(true, "The MDXQuery contains an MDXNamedSetDefinition node with the same expression as the target node.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The MDXQuery does not contain an MDXNamedSetDefinition node with the same expression as the target node.", trace);
        return false;
    }
}

