/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.namedsets;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveNamedSetOnlyReferencedFromNamedSet
extends Transformation {
    public RemoveNamedSetOnlyReferencedFromNamedSet(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "RemoveNamedSetOnlyReferencedFromNamedSet";
        this.mTypes = new int[]{1003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] nsRefs = mdxQuery.getDescendantsOfType(1014, false);
        for (int i = 0; i < nsRefs.length; ++i) {
            if (((MDXNamedSetReference)nsRefs[i]).getDefinition() != node) continue;
            nsRefs[i].getParent().exchangeChildNode(nsRefs[i], factory.deepCopyNode(node.getChild(0)), false);
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target MDXNamedSetDefinition node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] nsRefs = mdxQuery.getDescendantsOfType(1014, false);
        int numberOfReferences = 0;
        boolean isProjectedBySecondDescendantOfGenerate = false;
        boolean isProjectedByNamedSetDefinition = false;
        for (int i = 0; i < nsRefs.length; ++i) {
            if (((MDXNamedSetReference)nsRefs[i]).getDefinition() != node) continue;
            ++numberOfReferences;
            if (nsRefs[i].getAncestorOfType(1003) != null) {
                isProjectedByNamedSetDefinition = true;
            }
            if (!((MDXNamedSetReference)nsRefs[i]).isDescendantOfChildAtIndexForNodeOfType(1057, 1, true)) continue;
            isProjectedBySecondDescendantOfGenerate = true;
        }
        if (numberOfReferences == 1 && isProjectedByNamedSetDefinition && !isProjectedBySecondDescendantOfGenerate) {
            this.traceNodeCondition(true, "The target MDXNamedSetDefinition node has a single MDXNamedSetReference that is projected by another MDXNamedSetDefinition node and that is not part of the second subtree of an MDXGenerate node.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The target MDXNamedSetDefinition node does not have a single MDXNamedSetReference that is projected by another MDXNamedSetDefinition node and that is not part of the second subtree of an MDXGenerate node.", trace);
        return false;
    }
}

