/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.namedsets;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTESharedPassNumbers;

public final class RemoveNamedSetWithNamedSetDefinition
extends Transformation {
    public RemoveNamedSetWithNamedSetDefinition(QTESharedPassNumbers sharedPassNumbers) {
        super(sharedPassNumbers);
        this.mName = "Remove Named Set With Named Set Definition";
        this.mTypes = new int[]{1003};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] nsRefs = mdxQuery.getDescendantsOfType(1014, false);
        for (int i = 0; i < nsRefs.length; ++i) {
            if (((MDXNamedSetReference)nsRefs[i]).getDefinition() != node) continue;
            nsRefs[i].getParent().exchangeChildNode(nsRefs[i], factory.deepCopyNode(node.getChild(0)), false);
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child categories of the target MDXNamedSetDefinition node are invalid.", trace);
            return false;
        }
        if (node.getChild(0).getType() == 1014 && ((MDXNamedSetReference)node.getChild(0)).getDefinition() != node) {
            this.traceNodeCondition(true, "The definition of the target MDXNamedSetDefinition node is a reference to another named set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The definition of the target MDXNamedSetDefinition node is not a reference to another named set.", trace);
        return false;
    }
}

