/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.optimization.summary;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class ReplaceROLAPRelativeTimeMember
extends Transformation {
    public ReplaceROLAPRelativeTimeMember() {
        this.mPassNumbers = new int[]{41};
        this.mName = "Replace base members with the relative time calculation.";
        this.mTypes = new int[]{1067};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        BaseMember baseMember = (BaseMember)node;
        MDXCalculatedMemberReference cubeCalculatedDefaultMember = this.searchCalculatedDefaultMemberRef(mdxQuery, baseMember);
        cubeCalculatedDefaultMember.setCopyDefinition(false);
        XQENodeFactory nf = environment.getNodeFactory();
        MDXCalculatedMemberReference cubeCalculatedDefaultMemberCopy = (MDXCalculatedMemberReference)nf.copyNode(cubeCalculatedDefaultMember);
        cubeCalculatedDefaultMemberCopy.setPropertyValue("isDefaultMember", Boolean.TRUE);
        baseMember.exchange(cubeCalculatedDefaultMemberCopy);
        MDXCalculatedMemberDefinition calcDef = cubeCalculatedDefaultMember.getDefinition();
        if (calcDef.getParent() == null) {
            mdxQuery.addChild(calcDef);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        BaseMember baseMember = (BaseMember)node;
        if (baseMember.getExternalName() == null || !baseMember.getHierarchy().getDimension().isTimeDimension()) {
            this.traceNodeCondition(false, "The member does not belong to the Time hierarchy with an external name.", trace);
            return false;
        }
        MDXCalculatedMemberReference cubeCalculatedDefaultMember = this.searchCalculatedDefaultMemberRef(mdxQuery, baseMember);
        if (cubeCalculatedDefaultMember != null) {
            this.traceNodeCondition(true, "Able to replace the member with a resolved calculated member reference.", trace);
            return true;
        }
        this.traceNodeCondition(false, "No calculation exists to replace the member.", trace);
        return false;
    }

    private MDXCalculatedMemberReference searchCalculatedDefaultMemberRef(MDXQuery mdxQuery, BaseMember member) {
        IXQEQueryNode[] relativeTimeList;
        for (IXQEQueryNode n : relativeTimeList = mdxQuery.getDescendantsOfType(1187, false)) {
            MDXCalculatedMemberDefinition calcMemberDef;
            if (!member.getExternalName().equals(n.getPropertyValue("externalMun")) || (calcMemberDef = ((MDXCalculatedMemberReference)n.getChild(0)).getDefinition()).hasDescendantOfType(1013, false)) continue;
            return (MDXCalculatedMemberReference)n.getChild(0);
        }
        return null;
    }
}

