/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.projection;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXReportSummaryExpr;
import com.cognos.xqe.ast.olap.MDXAscendants;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXHierarchize;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class MakeNestedGroupedMDXMemberOnHierarchyContextDependent
extends Transformation {
    public MakeNestedGroupedMDXMemberOnHierarchyContextDependent() {
        this.mName = "Make Nested Grouped MDXMembers On Hierarchy Expressions Context Dependent.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{1040};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXHierInfo mdxMembersHierInfo = ((MDXMembers)node).getHierarchyInfo();
        IHierarchy hierarchy = mdxMembersHierInfo.getProjectedHierarchy(0);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXNode nodeToFindContextFrom = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((MDXMembers)node, mdxQuery);
        MDXLevelInfo contextLevelInfo = nodeToFindContextFrom.getContextLevelInfo();
        if (contextLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            MDXAscendants mdxAscendants = MDXBuilder.buildMDXAscendantsExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            MDXHierarchize mdxHierarchize = MDXBuilder.buildMDXHierarchizeExpr(factory, mdxAscendants);
            mdxAscendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr((IXQENodeFactory)factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), 0, 2);
            mdxDescendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            AbstractMDXNode[] children = new AbstractMDXNode[]{mdxHierarchize, mdxDescendants};
            MDXSet mdxSet = MDXBuilder.buildMDXSetExpr((IXQENodeFactory)factory, children);
            mdxSet.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            node.getParent().exchangeChildNode(node, mdxSet, false);
        } else {
            int contextHighestLevelIndex = contextLevelInfo.getHighestProjectedLevel(hierarchy).getIndex();
            int contextLowestLevelIndex = contextLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
            this.createContextDependentSet(factory, node, hierarchy, contextHighestLevelIndex, contextLowestLevelIndex, true);
        }
    }

    protected IXQEQueryNode createContextDependentSet(IXQENodeFactory factory, IXQEQueryNode node, IHierarchy hierarchy, int contextHighestLevelIndex, int contextLowestLevelIndex, boolean bReplaceNode) {
        if (contextHighestLevelIndex == contextLowestLevelIndex && contextHighestLevelIndex == 0) {
            MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), 0, 4);
            mdxDescendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            if (bReplaceNode) {
                node.getParent().exchangeChildNode(node, mdxDescendants, false);
            }
            return mdxDescendants;
        }
        if (contextHighestLevelIndex == contextLowestLevelIndex && contextHighestLevelIndex == hierarchy.getLevelCount() - 1) {
            MDXAscendants mdxAscendants = MDXBuilder.buildMDXAscendantsExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            MDXHierarchize mdxHierarchize = MDXBuilder.buildMDXHierarchizeExpr(factory, mdxAscendants);
            mdxAscendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
            if (bReplaceNode) {
                node.getParent().exchangeChildNode(node, mdxHierarchize, false);
            }
            return mdxHierarchize;
        }
        MDXAscendants mdxAscendants = MDXBuilder.buildMDXAscendantsExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
        mdxAscendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
        MDXHierarchize mdxHierarchize = MDXBuilder.buildMDXHierarchizeExpr(factory, mdxAscendants);
        MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), 0, 2);
        mdxDescendants.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
        AbstractMDXNode[] children = new AbstractMDXNode[]{mdxHierarchize, mdxDescendants};
        MDXSet mdxSet = MDXBuilder.buildMDXSetExpr(factory, children);
        mdxSet.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
        if (bReplaceNode) {
            node.getParent().exchangeChildNode(node, mdxSet, false);
        }
        return mdxSet;
    }

    protected static IHierarchy getHierarchyForReportSummary(IXQEQueryNode nodeToCheck, AbstractMDXNode node) {
        MDXCalculatedMemberReference ref;
        MDXCalculatedMemberDefinition def;
        Boolean asReportSummay;
        if (nodeToCheck.getType() == 1013 && (asReportSummay = (Boolean)(def = (ref = (MDXCalculatedMemberReference)nodeToCheck).getDefinition()).getPropertyValue("treatedAsReportSummary")) != null && asReportSummay.equals(true) && node.isAncestor(def)) {
            MDXHierInfo hierInfo = node.getHierarchyInfo();
            return hierInfo.getProjectedHierarchy(0);
        }
        MDXHierInfo mdxMembersHierInfo = ((AbstractMDXNode)nodeToCheck).getHierarchyInfo();
        return mdxMembersHierInfo.getProjectedHierarchy(0);
    }

    protected static AbstractMDXNode getNodeToCheckContextFrom(AbstractMDXNode node, MDXQuery mdxQuery) {
        MDXHierInfo hierInfo = node.getHierarchyInfo();
        if (hierInfo.getNumProjectedHierarchies() == 0) {
            return null;
        }
        MDXLevelInfo levelInfo = null;
        IHierarchy hierarchy = hierInfo.getProjectedHierarchy(0);
        CogMDXReportSummaryExpr reportSummary = (CogMDXReportSummaryExpr)node.getAncestorOfType(1028);
        if (reportSummary != null) {
            levelInfo = node.getContextLevelInfo(reportSummary);
            if (levelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                return node;
            }
            if (reportSummary.getHierarchy() == hierarchy) {
                return reportSummary;
            }
            return null;
        }
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        if (calcDef != null) {
            levelInfo = node.getContextLevelInfo(calcDef);
            if (levelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) {
                return node;
            }
            Boolean bFoundReportSummary = null;
            if (!calcDef.getHierarchy().equals(hierarchy) && ((bFoundReportSummary = (Boolean)calcDef.getPropertyValue("treatedAsReportSummary")) == null || bFoundReportSummary.equals(false))) {
                return null;
            }
            List<IXQEQueryNode> references = mdxQuery.getCalcMemberRefForDefinition(calcDef);
            if (references.size() != 1) {
                return null;
            }
            MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)references.get(0);
            MDXEdge edge = (MDXEdge)calcRef.getAncestorOfType(1006);
            if (bFoundReportSummary != null && bFoundReportSummary.equals(true)) {
                return calcRef;
            }
            if (edge != null && !((AbstractMDXSet)edge.getChild(0)).isProjectedDescendant(calcRef)) {
                return null;
            }
            return MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((AbstractMDXNode)references.get(0), mdxQuery);
        }
        MDXEdge mdxEdge = (MDXEdge)node.getAncestorOfType(1006);
        if (mdxEdge != null) {
            return node;
        }
        return null;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((MDXMembers)node).isFlaggedContextIndependent()) {
            this.traceNodeCondition(false, "The MDXMembers node is flagged as context independent.", trace);
            return false;
        }
        if (!((MDXMembers)node).validateChildCategories()) {
            this.traceNodeCondition(false, "The operands of the MDXMembers node are invalid.", trace);
            return false;
        }
        if (!((MDXMembers)node).getChild(0).isOfCategory(1072)) {
            this.traceNodeCondition(false, "The MDXMembers expression is not applied to a level.", trace);
            return false;
        }
        IXQEQueryNode cogMDXNest = node.getAncestorOfType(1026);
        if (cogMDXNest != null) {
            this.traceNodeCondition(false, "The MDXMembers expression is not part of a grouped expression.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceQueryCondition(false, "The target MDXMembers node is not a descendant of an MDXQuery node.", trace);
            return false;
        }
        AbstractMDXNode nodeToCheck = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((MDXMembers)node, mdxQuery);
        if (nodeToCheck == null) {
            return false;
        }
        IHierarchy hierarchy = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getHierarchyForReportSummary(nodeToCheck, (AbstractMDXNode)node);
        MDXHierInfo contextHierInfo = nodeToCheck.getContextHierarchyInfo();
        if (!contextHierInfo.projectsHierarchy(hierarchy)) {
            this.traceNodeCondition(false, "The target MDXMembers expression does not have context information that includes the hierarchy projected by the MDXMembers expression.", trace);
            return false;
        }
        MDXLevelInfo contextLevelInfo = nodeToCheck.getContextLevelInfo();
        contextLevelInfo.removeNoMemberLevels(hierarchy);
        if (contextLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            this.traceNodeCondition(false, "there is only hierarchy normalization in context fro this hierarchy.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target MDXMembers expression is a descendant of a CogMDXGroup node for which the context information includes the hierarchy projected by the MDXMembers expression.", trace);
        return true;
    }
}

