/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.projection;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.projection.RemoveInvalidTuplesFromNestedGroupedSets;

public class RemoveInvalidMemberFromNestedGroupedSetsForDMR
extends Transformation {
    private static final String LOGICAL_NAME_MSG = "Unable to retrieve the logical name for node ";
    private static final String NODE_MSG = "Node ";

    public RemoveInvalidMemberFromNestedGroupedSetsForDMR() {
        this.mName = "Remove Invalid BaseMember From Nested Grouped Sets using DMR Unique name.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{1027};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        StringBuilder message = new StringBuilder();
        if (!RemoveInvalidTuplesFromNestedGroupedSets.passesNonDMRSpecificNodeConditions(node, message)) {
            if (message.length() > 0) {
                this.traceNodeCondition(false, message.toString(), environment.getTrace());
            }
            return false;
        }
        boolean toReturn = RemoveInvalidMemberFromNestedGroupedSetsForDMR.passesDMRSpecificNodeConditions(node, message);
        if (message.length() > 0) {
            this.traceNodeCondition(toReturn, message.toString(), environment.getTrace());
        }
        return toReturn;
    }

    public static boolean passesDMRSpecificNodeConditions(IXQEQueryNode node, StringBuilder message) {
        if (node.getPropertyValue("RemoveInvalidTuplesFromNestedSetExpression") != null) {
            message.append("The correlation already done or not required.");
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            message.append("The target CogMDXGroup node is not a descendant of an MDXQuery node.");
            return false;
        }
        if (!((Boolean)mdxQuery.getPropertyValue("isDMR")).booleanValue()) {
            message.append("The query is not DMR");
        }
        if (!RemoveInvalidMemberFromNestedGroupedSetsForDMR.validateMDXGroup(node, true, message)) {
            return false;
        }
        if (!RemoveInvalidMemberFromNestedGroupedSetsForDMR.validateMDXGroup(node.getParent().getParent(), false, message)) {
            return false;
        }
        message.append("The CogMDXGroup nesting can be validated using the BaseMember(s) logical name.");
        return true;
    }

    private static boolean validateMDXGroup(IXQEQueryNode node, boolean isNested, StringBuilder message) {
        if (!(node instanceof CogMDXGroup)) {
            message.append(NODE_MSG);
            message.append(node.getId());
            message.append(" is not of type CogMDXGroup.");
            return false;
        }
        CogMDXGroup mdxGroup = (CogMDXGroup)node;
        IXQEQueryNode[] nodes = mdxGroup.getChildren();
        if (isNested && !(node.getParent() instanceof MDXSet)) {
            message.append(NODE_MSG);
            message.append(node.getParent().getId());
            message.append(" is parent node not of type MDXSet.");
            return false;
        }
        if (!(nodes[0] instanceof MDXSet)) {
            message.append(NODE_MSG);
            message.append(nodes[0].getId());
            message.append(" is not of type MDXSet.");
            return false;
        }
        if (node.getChildren().length != 1 && node.getChildren()[0].getChildren().length != 1) {
            message.append(NODE_MSG);
            message.append(node.getChildren()[0].getId());
            message.append(" does must have exactly 1 child.");
            return false;
        }
        for (IXQEQueryNode member : node.getChildren()[0].getChildren()) {
            if (!(member instanceof BaseMember)) {
                message.append(NODE_MSG);
                message.append(member.getId());
                message.append(" is not of type BaseMember.");
                return false;
            }
            Object o = member.getPropertyValue("logical");
            if (o != null) continue;
            message.append(LOGICAL_NAME_MSG);
            message.append(member.getId());
            return false;
        }
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] memberBaseChildren = node.getParent().getParent().getChild(0).getChildren();
        BaseMember baseMember = (BaseMember)memberBaseChildren[0];
        Object o = baseMember.getPropertyValue("logical");
        String parentLogicalName = (String)o;
        for (IXQEQueryNode queryNode : node.getChildren()[0].getChildren()) {
            BaseMember member = (BaseMember)queryNode;
            String logicalName = (String)member.getPropertyValue("logical");
            if (baseMember.getLevel().getIndex() < member.getLevel().getIndex() && !logicalName.regionMatches(0, parentLogicalName, 0, parentLogicalName.length())) {
                queryNode.detach();
                node.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
                continue;
            }
            node.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
        }
        if (node.getChildren().length == 1 && node.getChildren()[0].getChildren().length == 0) {
            node.detach();
        }
    }
}

