/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.projection;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.CogMDXEmptySet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXAscendants;
import com.cognos.xqe.ast.olap.MDXDescendants;
import com.cognos.xqe.ast.olap.MDXIntersect;
import com.cognos.xqe.ast.olap.MDXMembers;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.TNodeUnbCompensation;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.transformation.olap.projection.MakeNestedGroupedMDXMemberOnHierarchyContextDependent;
import com.cognos.xqe.transformation.olap.projection.RemoveInvalidMemberFromNestedGroupedSetsForDMR;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;

public final class RemoveInvalidTuplesFromNestedGroupedSets
extends Transformation {
    public RemoveInvalidTuplesFromNestedGroupedSets() {
        this.mName = "Remove Invalid Tuples From Nested Grouped Sets.";
        this.mPassNumbers = new int[]{20};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXNode nodeToFindContextFrom = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((AbstractMDXNode)node, mdxQuery);
        MDXLevelInfo contextLevelInfo = nodeToFindContextFrom.getContextLevelInfo();
        AbstractMDXSet groupSet = (AbstractMDXSet)node.getChild(0);
        ArrayList<AbstractMDXSet> nestedSets = new ArrayList<AbstractMDXSet>();
        MDXLevelInfo setInfo = groupSet.getLevelInfo();
        IHierarchy hierarchy = setInfo.getHierarchyInfo().getProjectedHierarchy(0);
        int contextLowestLevelIndex = contextLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
        this.getFilteringSets(groupSet, nestedSets, contextLowestLevelIndex);
        for (AbstractMDXSet nestedGroupSet : nestedSets) {
            setInfo = nestedGroupSet.getLevelInfo();
            int contextHighestLevelIndex = contextLevelInfo.getHighestProjectedLevel(hierarchy).getIndex();
            contextLowestLevelIndex = contextLevelInfo.getLowestProjectedLevel(hierarchy).getIndex();
            this.createContextDependentSet(factory, nestedGroupSet, setInfo, hierarchy, contextHighestLevelIndex, contextLowestLevelIndex, true);
        }
        node.setPropertyValue("RemoveInvalidTuplesFromNestedSetExpression", "applied");
    }

    private void getFilteringSets(AbstractMDXSet groupSet, List<AbstractMDXSet> nestedSets, int contextLowestLevelIndex) {
        IXQEQueryNode[] children;
        boolean appliedToChild = false;
        for (IXQEQueryNode child : children = groupSet.getChildrenOfCategory(1021)) {
            AbstractMDXSet setChild = (AbstractMDXSet)child;
            if (groupSet.getType() == 1057) {
                if (groupSet.getPositionOfChild(setChild) == 0) {
                    MDXLevelInfo firstSetLevelInfo = setChild.getLevelInfo();
                    MDXLevelInfo generateLevelInfo = groupSet.getLevelInfo();
                    if (!firstSetLevelInfo.getHierarchyInfo().projectedHierarchiesOverlap(generateLevelInfo.getHierarchyInfo())) continue;
                    IHierarchy hierarchy = firstSetLevelInfo.getHierarchyInfo().getProjectedHierarchy(0);
                    if (contextLowestLevelIndex < firstSetLevelInfo.getHighestProjectedLevel(hierarchy).getIndex()) {
                        nestedSets.add(groupSet);
                    }
                }
                if (setChild.projectsOnlyAscendantsOrDescendantsOfCurrentMember(true)) continue;
                appliedToChild = true;
                this.getFilteringSets(setChild, nestedSets, contextLowestLevelIndex);
                continue;
            }
            if (!groupSet.isProjectedDescendant(setChild)) continue;
            appliedToChild = true;
            this.getFilteringSets(setChild, nestedSets, contextLowestLevelIndex);
        }
        if (groupSet.getType() == 1039 && children.length != groupSet.getNumberChildren()) {
            nestedSets.add(groupSet);
            for (IXQEQueryNode child : children) {
                nestedSets.remove(child);
            }
        }
        if (!appliedToChild) {
            nestedSets.add(groupSet);
        }
    }

    protected MDXIntersect createContextDependentSet(IXQENodeFactory factory, AbstractMDXSet groupSet, MDXLevelInfo setInfo, IHierarchy hierarchy, int contextHighestLevelIndex, int contextLowestLevelIndex, boolean bReplaceSet) {
        if (setInfo == null || setInfo.getHighestProjectedLevel(hierarchy) == null) {
            CogMDXEmptySet cogMDXEmptySet = (CogMDXEmptySet)factory.createNode(1145);
            BaseHierarchy hier = MDXBuilder.buildMDXBaseHierarchyExpr(factory, hierarchy);
            cogMDXEmptySet.addChild(hier);
            if (bReplaceSet) {
                groupSet.getParent().exchangeChildNode(groupSet, cogMDXEmptySet, false);
            }
            return null;
        }
        int groupSetHighestLevelIndex = setInfo.getHighestProjectedLevel(hierarchy).getIndex();
        int groupSetLowestLevelIndex = setInfo.getLowestProjectedLevel(hierarchy).getIndex();
        MDXIntersect mdxIntersect = (MDXIntersect)factory.createNode(1038);
        if (bReplaceSet) {
            groupSet.getParent().exchangeChildNode(groupSet, mdxIntersect, false);
        }
        mdxIntersect.addChild(groupSet);
        mdxIntersect.setAll(true);
        if (groupSetHighestLevelIndex == groupSetLowestLevelIndex) {
            if (contextLowestLevelIndex == contextHighestLevelIndex && contextHighestLevelIndex == groupSetHighestLevelIndex) {
                MDXSet mdxCurrentMemberSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
                mdxIntersect.addChild(mdxCurrentMemberSet);
            } else if (contextLowestLevelIndex <= groupSetHighestLevelIndex) {
                MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), MDXBuilder.buildMDXBaseLevelExpr(factory, setInfo.getHighestProjectedLevel(hierarchy)), 0);
                mdxIntersect.addChild(mdxDescendants);
            } else if (contextHighestLevelIndex >= groupSetLowestLevelIndex) {
                MDXSet mdxAncestorSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXAncestorExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), MDXBuilder.buildMDXBaseLevelExpr(factory, setInfo.getHighestProjectedLevel(hierarchy))));
                mdxIntersect.addChild(mdxAncestorSet);
            } else {
                MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), MDXBuilder.buildMDXBaseLevelExpr(factory, setInfo.getHighestProjectedLevel(hierarchy)), 0);
                MDXSet mdxAncestorSet = MDXBuilder.buildMDXSetExpr(factory, MDXBuilder.buildMDXAncestorExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXParentExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy)), MDXBuilder.buildMDXBaseLevelExpr(factory, setInfo.getHighestProjectedLevel(hierarchy))));
                AbstractMDXNode[] children = new AbstractMDXNode[]{mdxAncestorSet, mdxDescendants};
                MDXSet mdxSet = MDXBuilder.buildMDXSetExpr(factory, children);
                mdxIntersect.addChild(mdxSet);
            }
        } else if (contextLowestLevelIndex <= groupSetHighestLevelIndex) {
            MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), MDXBuilder.buildMDXBaseLevelExpr(factory, setInfo.getLowestProjectedLevel(hierarchy)), 5);
            mdxIntersect.addChild(mdxDescendants);
        } else if (contextHighestLevelIndex >= groupSetLowestLevelIndex) {
            MDXAscendants mdxAscendants = MDXBuilder.buildMDXAscendantsExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            mdxIntersect.addChild(mdxAscendants);
        } else {
            MDXDescendants mdxDescendants = MDXBuilder.buildMDXDescendantsExpr(factory, (AbstractMDXMember)MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy), MDXBuilder.buildMDXBaseLevelExpr(factory, setInfo.getLowestProjectedLevel(hierarchy)), 5);
            MDXAscendants mdxAscendants = MDXBuilder.buildMDXAscendantsExpr(factory, MDXBuilder.buildMDXCurrentMemberExpr(factory, hierarchy));
            AbstractMDXNode[] children = new AbstractMDXNode[]{mdxAscendants, mdxDescendants};
            MDXSet mdxSet = MDXBuilder.buildMDXSetExpr(factory, children);
            mdxIntersect.addChild(mdxSet);
        }
        return mdxIntersect;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        StringBuilder sb = new StringBuilder();
        if (RemoveInvalidMemberFromNestedGroupedSetsForDMR.passesDMRSpecificNodeConditions(node, sb)) {
            this.traceNodeCondition(false, "The query is DMR and satisfies the conditions for transformation RemoveInvalidTuplesFromNestedGroupedSetsForDMR", environment.getTrace());
            return false;
        }
        return RemoveInvalidTuplesFromNestedGroupedSets.passesNonDMRSpecificNodeConditions(node, sb);
    }

    static boolean passesNonDMRSpecificNodeConditions(IXQEQueryNode node, StringBuilder sb) {
        IHierarchy hierarchy;
        if (node.getPropertyValue("RemoveInvalidTuplesFromNestedSetExpression") != null) {
            sb.append("The correlation already done or not required.");
            return false;
        }
        if (((CogMDXGroup)node).isFlaggedContextIndependent()) {
            sb.append("The target CogMDXGroup node is flaged as context independent.");
            return false;
        }
        if (!((CogMDXGroup)node).validateChildCategories()) {
            sb.append("The operands of the target CogMDXGroup node are invalid.");
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            sb.append("The target CogMDXGroup node is not a descendant of an MDXQuery node.");
            return false;
        }
        AbstractMDXNode nodeToFindContextFrom = MakeNestedGroupedMDXMemberOnHierarchyContextDependent.getNodeToCheckContextFrom((AbstractMDXNode)node, mdxQuery);
        if (nodeToFindContextFrom == null) {
            return false;
        }
        MDXHierInfo setHierInfo = ((AbstractMDXSet)node.getChild(0)).getHierarchyInfo();
        MDXHierInfo contextHierInfo = nodeToFindContextFrom.getContextHierarchyInfo();
        if (!contextHierInfo.projectedHierarchiesOverlap(setHierInfo)) {
            sb.append("The target CogMDXGroup node is a descendant of a CogMDXGroup node for which the context information does not include the hierarchy projected by the first operand of the target CogMDXGroup node.");
            return false;
        }
        if (((AbstractMDXSet)node.getChild(0)).projectsOnlyAscendantsOrDescendantsOfCurrentMember(true)) {
            sb.append("The first operand of the CogMDXGroup node projects either ascendants or descendants (or both) of the members in context.");
            return false;
        }
        IXQEQueryNode[] mdxMembersExprs = node.getChild(0).getDescendantsOfType(1040, true);
        int numOfMembersUnderTNodeUnbCompSecondChild = 0;
        for (int i = 0; i < mdxMembersExprs.length; ++i) {
            MDXMembers mdxMembers = (MDXMembers)mdxMembersExprs[i];
            TNodeUnbCompensation tNodeUnbComp = (TNodeUnbCompensation)mdxMembers.getAncestorOfType(1113);
            if (tNodeUnbComp != null && mdxMembers.isAncestor(tNodeUnbComp.getChild(1))) {
                IXQEQueryNode headNode = mdxMembers.getAncestorOfType(1042);
                if (headNode != null && headNode.getNumberChildren() == 1 && headNode.getParent() != null && headNode.getParent().getType() == 1087) {
                    ++numOfMembersUnderTNodeUnbCompSecondChild;
                    continue;
                }
                if (!setHierInfo.projectedHierarchiesOverlap(mdxMembers.getHierarchyInfo())) {
                    ++numOfMembersUnderTNodeUnbCompSecondChild;
                    continue;
                }
            }
            if (mdxMembers.isFlaggedContextIndependent() || !setHierInfo.projectedHierarchiesOverlap(mdxMembers.getHierarchyInfo())) continue;
            sb.append("The first operand of the target CogMDXGroup node contains an MDXMembers node in the hierarchy " + mdxMembers.getHierarchyInfo().getProjectedHierarchy(0) + " that is flagged as context dependent and which projects a hierarchy that is also projected in the context information for the target CogMDXGroup node. MakeNestedGroupedMDXMemberOnLevelContextDependent or MakeNestedGroupedMDXMemberOnHierarchyContextDependent must be applied before this transformation.");
            return false;
        }
        if (mdxMembersExprs.length > 0 && mdxMembersExprs.length == numOfMembersUnderTNodeUnbCompSecondChild) {
            sb.append("No target MDXMembers node was found.");
            return false;
        }
        if (((CogMDXGroup)node).isEmpty()) {
            sb.append("The target CogMDXGroup node returns an empty set.");
            return false;
        }
        MDXLevelInfo setLevelInfo = ((AbstractMDXSet)node.getChild(0)).getLevelInfo();
        if (setLevelInfo.getNumProjectedLevels(hierarchy = setLevelInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 0) {
            sb.append("The first child of the target node does not project any members from ");
            sb.append(hierarchy);
            return false;
        }
        MDXLevelInfo contextLevelInfo = nodeToFindContextFrom.getContextLevelInfo();
        if (contextLevelInfo.getNumProjectedLevels(hierarchy) == 0) {
            sb.append("The context of the target node does not project any members from ");
            sb.append(hierarchy);
            return false;
        }
        sb.append("The context information for the target CogMDXGroup node includes the hierarchy projected by the first operand of the target CogMDXGroup node.");
        return true;
    }
}

