/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.AbstractMDXValueExpression;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.trace.XQETrace;

public final class OptimizeAdditionOfSums
extends Transformation {
    public OptimizeAdditionOfSums() {
        this.mName = "Replaces a sequence of additions of base members with a SUM function";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1084};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXSet set = (MDXSet)factory.createNode(1039);
        set.setMdxUnionAll(true);
        AbstractMDXValueExpression valExpr = (AbstractMDXValueExpression)node.getChild(0).getChild(1);
        valExpr.detach();
        AbstractMDXSet set1 = (AbstractMDXSet)node.getChild(0).getChild(0);
        set1.detach();
        set.addChild(set1);
        AbstractMDXSet set2 = (AbstractMDXSet)node.getChild(1).getChild(0);
        set2.detach();
        set.addChild(set2);
        MDXSummaryFunction sum = (MDXSummaryFunction)factory.createNode(1060);
        sum.setSummaryType(MDXSummaryFunctionTypeEnum.SUM);
        sum.addChild(set);
        sum.addChild(valExpr);
        node.exchange(sum);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        MDXNumericOperator numOp = (MDXNumericOperator)node;
        if (!mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "The query is not using local processing.", trace);
            return false;
        }
        if (!mdxQuery.getCapabilities().getStringValue("null.plus.operator", NullBehavior.ZERO.getKeywordValue()).equals(NullBehavior.ZERO.getKeywordValue())) {
            this.traceNodeCondition(false, "The null behaviour for the PLUS operator is not set to zero.", trace);
            return false;
        }
        if (numOp.getOperatorProperty() != 1) {
            this.traceNodeCondition(false, "Numeric operator is not an addition.", trace);
            return false;
        }
        if (node.getChild(0).getType() != 1060 || node.getChild(1).getType() != 1060) {
            this.traceNodeCondition(false, "Numeric operator is not adding two Summary functions.", trace);
            return false;
        }
        MDXSummaryFunction child1 = (MDXSummaryFunction)node.getChild(0);
        MDXSummaryFunction child2 = (MDXSummaryFunction)node.getChild(1);
        if (child1.getSummaryType() != MDXSummaryFunctionTypeEnum.SUM || child2.getSummaryType() != MDXSummaryFunctionTypeEnum.SUM) {
            this.traceNodeCondition(false, "Numeric operator is not adding two SUM functions.", trace);
            return false;
        }
        if (!((AbstractMDXSet)child1.getChild(0)).getHierarchyInfo().equals(((AbstractMDXSet)child2.getChild(0)).getHierarchyInfo())) {
            this.traceNodeCondition(false, "The SUMs are over sets from different hierarchies.", trace);
            return false;
        }
        if (child1.getNumberChildren() != 2 || child2.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The SUM functions do not specify a value expression.", trace);
            return false;
        }
        if (!((AbstractMDXValueExpression)child1.getChild(1)).isSameExpression((AbstractMDXValueExpression)child2.getChild(1), false)) {
            this.traceNodeCondition(false, "The SUM's value expressions are not the same.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The optimization can be applied.", trace);
        return true;
    }
}

