/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReplaceAdditionWithSum
extends Transformation {
    public ReplaceAdditionWithSum() {
        this.mName = "Replaces a sequence of additions of base members with a SUM function";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1084};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXNumericOperator op;
        IXQEQueryNode toAdd;
        XQENodeFactory factory;
        HashMap<MDXHierInfo, List<IXQEQueryNode>> plus = new HashMap<MDXHierInfo, List<IXQEQueryNode>>();
        HashMap<MDXHierInfo, List<IXQEQueryNode>> minus = new HashMap<MDXHierInfo, List<IXQEQueryNode>>();
        ArrayList<IXQEQueryNode> others = new ArrayList<IXQEQueryNode>();
        this.collectAdditiveOperations(node, plus, minus, others, true);
        IXQEQueryNode root = null;
        if (!plus.isEmpty()) {
            factory = environment.getNodeFactory();
            for (List values : plus.values()) {
                MDXSet set = (MDXSet)factory.createNode(1039);
                for (IXQEQueryNode baseMember : values) {
                    toAdd = baseMember;
                    if (toAdd.getType() == 1059) {
                        toAdd = toAdd.getChild(0);
                    }
                    toAdd.detach();
                    set.addChild(toAdd);
                }
                MDXSummaryFunction sum = (MDXSummaryFunction)factory.createNode(1060);
                sum.setSummaryType(MDXSummaryFunctionTypeEnum.SUM);
                sum.addChild(set);
                if (root == null) {
                    root = sum;
                    continue;
                }
                op = (MDXNumericOperator)factory.createNode(1084);
                op.setOperatorProperty(1);
                op.addChild(root);
                op.addChild(sum);
                root = op;
            }
        }
        if (!others.isEmpty()) {
            factory = environment.getNodeFactory();
            for (IXQEQueryNode value : others) {
                if (root == null) {
                    int operator = ((MDXNumericOperator)value.getParent()).getOperatorProperty();
                    if (operator == 5 || operator == 0 && value.getParent().getPositionOfChild(value) == 1) {
                        MDXNumericOperator op2 = (MDXNumericOperator)factory.createNode(1084);
                        op2.setOperatorProperty(5);
                        value.move(op2);
                        root = op2;
                        continue;
                    }
                    root = value.detach();
                    continue;
                }
                MDXNumericOperator op3 = (MDXNumericOperator)factory.createNode(1084);
                int operator = ((MDXNumericOperator)value.getParent()).getOperatorProperty();
                if (operator == 5) {
                    operator = 0;
                } else if (value.getParent().getPositionOfChild(value) == 0) {
                    operator = 1;
                }
                op3.setOperatorProperty(operator);
                op3.addChild(root);
                op3.addChild(value);
                root = op3;
            }
        }
        if (!minus.isEmpty()) {
            factory = environment.getNodeFactory();
            for (List values : minus.values()) {
                MDXSet set = (MDXSet)factory.createNode(1039);
                for (IXQEQueryNode baseMember : values) {
                    toAdd = baseMember;
                    if (toAdd.getType() == 1059) {
                        toAdd = toAdd.getChild(0);
                    }
                    toAdd.detach();
                    set.addChild(toAdd);
                }
                MDXSummaryFunction sum = (MDXSummaryFunction)factory.createNode(1060);
                sum.setSummaryType(MDXSummaryFunctionTypeEnum.SUM);
                sum.addChild(set);
                if (root == null) {
                    op = (MDXNumericOperator)factory.createNode(1084);
                    op.setOperatorProperty(5);
                    op.addChild(sum);
                    root = op;
                    continue;
                }
                op = (MDXNumericOperator)factory.createNode(1084);
                op.setOperatorProperty(0);
                op.addChild(root);
                op.addChild(sum);
                root = op;
            }
        }
        node.exchange(root);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!mdxQuery.getCapabilities().getStringValue("null.plus.operator", NullBehavior.ZERO.getKeywordValue()).equals(NullBehavior.ZERO.getKeywordValue())) {
            this.traceNodeCondition(false, "The null behaviour for the PLUS operator is not set to zero.", trace);
            return false;
        }
        if (!mdxQuery.getCapabilities().getBooleanValue("mdx.replaceAdditionOperatorWithSUM", false)) {
            this.traceQueryCondition(false, "Replacing addition with SUM is not enabled.", trace);
            return false;
        }
        int opType = ((MDXNumericOperator)node).getOperatorProperty();
        if (opType != 1 && opType != 0) {
            this.traceQueryCondition(false, "The numeric operator is not an addition operation.", trace);
            return false;
        }
        IXQEQueryNode parent = node.getParent();
        if (parent.getType() == 1084 && (((MDXNumericOperator)parent).getOperatorProperty() == 1 || ((MDXNumericOperator)parent).getOperatorProperty() == 0) && parent.getPositionOfChild(node) == 0) {
            this.traceQueryCondition(false, "This node is not the top-most additive operator.", trace);
            return false;
        }
        HashMap<MDXHierInfo, List<IXQEQueryNode>> plus = new HashMap<MDXHierInfo, List<IXQEQueryNode>>();
        HashMap<MDXHierInfo, List<IXQEQueryNode>> minus = new HashMap<MDXHierInfo, List<IXQEQueryNode>>();
        ArrayList<IXQEQueryNode> others = new ArrayList<IXQEQueryNode>();
        this.collectAdditiveOperations(node, plus, minus, others, true);
        if (!plus.isEmpty()) {
            for (List values : plus.values()) {
                if (values.size() <= 1) continue;
                this.traceQueryCondition(true, "We have at least one addition that can be replaced with a SUM.", trace);
                return true;
            }
        }
        if (!minus.isEmpty()) {
            for (List values : minus.values()) {
                if (values.size() <= 1) continue;
                this.traceQueryCondition(true, "We have at least one minus that can be replaced with a SUM.", trace);
                return true;
            }
        }
        this.traceQueryCondition(false, "The addition expression can not be rewritten with a SUM function.", trace);
        return false;
    }

    private void collectAdditiveOperations(IXQEQueryNode node, Map<MDXHierInfo, List<IXQEQueryNode>> plus, Map<MDXHierInfo, List<IXQEQueryNode>> minus, List<IXQEQueryNode> others, boolean firstChild) {
        if (firstChild && node.getType() == 1084 && ((MDXNumericOperator)node).getOperatorProperty() == 5) {
            MDXHierInfo hierInfo = this.getHierarchyInfo(node.getChild(0));
            if (hierInfo != null) {
                List<IXQEQueryNode> nodes = minus.get(hierInfo);
                if (nodes == null) {
                    nodes = new ArrayList<IXQEQueryNode>();
                    minus.put(hierInfo, nodes);
                }
                nodes.add(node.getChild(0));
            } else {
                others.add(node.getChild(0));
            }
            return;
        }
        if (firstChild && node.getType() == 1084 && (((MDXNumericOperator)node).getOperatorProperty() == 0 || ((MDXNumericOperator)node).getOperatorProperty() == 1)) {
            for (int i = 0; i < node.getChildren().length; ++i) {
                IXQEQueryNode child = node.getChild(i);
                if (child.getType() == 1089) continue;
                this.collectAdditiveOperations(child, plus, minus, others, i == 0);
            }
            return;
        }
        MDXHierInfo hierInfo = this.getHierarchyInfo(node);
        if (hierInfo != null && node.getParent().getType() == 1084) {
            int op = ((MDXNumericOperator)node.getParent()).getOperatorProperty();
            if (op == 0 && node.getParent().getPositionOfChild(node) != 0) {
                List<IXQEQueryNode> nodes = minus.get(hierInfo);
                if (nodes == null) {
                    nodes = new ArrayList<IXQEQueryNode>();
                    minus.put(hierInfo, nodes);
                }
                nodes.add(node);
            } else {
                List<IXQEQueryNode> nodes = plus.get(hierInfo);
                if (nodes == null) {
                    nodes = new ArrayList<IXQEQueryNode>();
                    plus.put(hierInfo, nodes);
                }
                nodes.add(node);
            }
        } else {
            others.add(node);
        }
    }

    private MDXHierInfo getHierarchyInfo(IXQEQueryNode node) {
        IXQEQueryNode nodeToEvaluate = node;
        if (nodeToEvaluate.getType() == 1059) {
            nodeToEvaluate = nodeToEvaluate.getChild(0);
        }
        if (nodeToEvaluate.getType() == 1069) {
            for (IXQEQueryNode child : nodeToEvaluate.getChildren()) {
                if (child.getType() == 1067) continue;
                return null;
            }
            return ((MDXTuple)nodeToEvaluate).getHierarchyInfo();
        }
        return null;
    }
}

