/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5InvalidPropertyValueException;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public final class SetNullBehaviour
extends ProviderTransformation {
    public static final String PROPAGATE_NULLS_IN_COMPUTATIONS = "propagateNullsInComputations";
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public SetNullBehaviour() {
        super(new String[]{"PC", "TM"});
        this.mName = "Set the null behaviour property on the MDQuerySpec.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        MDXQuery mdxQuery = (MDXQuery)node;
        ICube cube = mdxQuery.getMDXFrom().getCube();
        mdxQuery.setNullExpressionBehavior(this.getBehaviour(v5QuerySet, mdxQuery, cube));
    }

    private MDXQuery.NullExpressionBehavior getBehaviour(V5QuerySet v5QuerySet, MDXQuery mdxQuery, ICube cube) {
        String behaviour;
        String valueFromQuery = (String)v5QuerySet.getPropertyValue(PROPAGATE_NULLS_IN_COMPUTATIONS);
        String valueFromDatasouceString = (String)cube.getModelDataSource().getProperty(PROPAGATE_NULLS_IN_COMPUTATIONS);
        MDXQuery.NullExpressionBehavior nullBehaviour = MDXQuery.NullExpressionBehavior.MDXBEHAVIOR;
        boolean propagateNullsInComputations = true;
        if (valueFromQuery != null) {
            if (!valueFromQuery.equals(TRUE) && !valueFromQuery.equals(FALSE)) {
                throw new V5InvalidPropertyValueException(XQEMessageKeys.V5_InvalidPropertyValue, valueFromQuery);
            }
            if (valueFromQuery.equals(FALSE)) {
                propagateNullsInComputations = false;
            }
        } else if (valueFromDatasouceString != null && valueFromDatasouceString.equals(FALSE)) {
            propagateNullsInComputations = false;
        }
        if (propagateNullsInComputations && (nullBehaviour = MDXQuery.NullExpressionBehavior.valueOfV5String(behaviour = mdxQuery.getCapabilities().getStringValue("mdx.mdqs.NullExpressionBehavior", MDXQuery.NullExpressionBehavior.PPYBEHAVIOR.toString()))) == MDXQuery.NullExpressionBehavior.UNKNOWN) {
            v5QuerySet.throwInternalError("Unknown MDX expression behavior found in the capabilities: " + behaviour);
        }
        return nullBehaviour;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceQueryCondition(false, "The provider type is not PC or TM1.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        if (mdxQuery.getNullExpressionBehavior() != null) {
            this.traceNodeCondition(false, "The NULL expression behaviour is already set.", trace);
            return false;
        }
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        if (v5QuerySet == null) {
            this.traceNodeCondition(false, "Unable to find ancestor query set node.", trace);
            return false;
        }
        ICube cube = mdxQuery.getMDXFrom().getCube();
        if (cube == null) {
            this.traceNodeCondition(false, "Unable to find cube object.", trace);
            return false;
        }
        MDXQuery.NullExpressionBehavior nullBehaviour = this.getBehaviour(v5QuerySet, mdxQuery, cube);
        if (nullBehaviour == MDXQuery.NullExpressionBehavior.UNSPECIFIED) {
            this.traceNodeCondition(false, "Unspecified NULL expression behaviour.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The NULL expression behaviour can be set.", trace);
        return true;
    }
}

