/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXHierarchy;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueExpression;
import com.cognos.xqe.ast.olap.MDXLevels;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;

public class ConvertLevelsToGenerationsFunction
extends EssbaseTransformation {
    public ConvertLevelsToGenerationsFunction() {
        this.mName = "Convert Count Function with ExcludeEmpty Flag to NonEmptyCount Function.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1066};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXLevels levels = (MDXLevels)node;
        boolean incrementValue = true;
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
        if (capabilities.isSupported("v5.useLocalOLAP")) {
            incrementValue = false;
        }
        IXQEQueryNode generations = factory.createNode(1166);
        AbstractMDXHierarchy hierarchy = (AbstractMDXHierarchy)levels.getChild(0);
        AbstractMDXNumericValueExpression levelExpr = (AbstractMDXNumericValueExpression)levels.getChild(1);
        levels.exchange(generations, true);
        if (levelExpr.getType() == 1064 && ((MDXNumericConstant)levelExpr).getConstantValue() instanceof Integer) {
            int value = (Integer)((MDXNumericConstant)levelExpr).getConstantValue();
            ++value;
            if (hierarchy.getHierarchy().getDimension().isMeasuresDimension() && incrementValue) {
                ++value;
            }
            ((MDXNumericConstant)levelExpr).setConstantValue(value);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        this.traceNodeCondition(status, "The LEVELS function exists.", trace);
        return status;
    }
}

