/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.List;

public class ExpandEssbaseNamedSetMultiPartIdentifier
extends EssbaseTransformation {
    public ExpandEssbaseNamedSetMultiPartIdentifier() {
        this.mName = "Expand Essbase NamedSet to a list of members.";
        this.mPassNumbers = new int[]{26};
        this.mTypes = new int[]{201116};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider("EB");
        ICube cube = ((INamedSet)((V5BoundModelIdentifier)node).getMetadata()).getDimension().getCube();
        IModelDataSource cubeDataSource = cube.getModelDataSource();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(execEnv.getOrAddDataSource(cube), execEnv, cubeDataSource.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        restrictions.add(RestrictionType.CATALOG, cube.getModelDataSource().getCatalog().getUniqueName());
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        String[] nameParts = ((V5BoundModelIdentifier)node).getNameParts();
        restrictions.add(RestrictionType.SET, nameParts[nameParts.length - 1]);
        List<MemberRecord> records = metadataProvider.getNamedSetMembers(restrictions);
        metadataProvider.release();
        XQENodeFactory factory = environment.getNodeFactory();
        V5SetFunction set = (V5SetFunction)factory.createNode(201101);
        ILevel level = null;
        for (MemberRecord record : records) {
            V5BoundToMetadata munNode;
            IDimension dimension = cube.getDimension(record.getDimensionUniqueName());
            IHierarchy hierarchy = dimension.getHierarchy(record.getHierarchyUniqueName());
            String externalMUN = record.getUniqueName();
            if (dimension.isMeasuresDimension()) {
                List<ILevel> levels = hierarchy.getLevels();
                for (ILevel mlevel : levels) {
                    if (mlevel.getIndex() != record.getLevelNumber()) continue;
                    level = mlevel;
                    break;
                }
                IMember measure = null;
                for (IMember member : level.getMembers()) {
                    if (!member.getUniqueName().equals(externalMUN)) continue;
                    measure = member;
                    break;
                }
                if (measure == null) {
                    throw new InternalError("Error expanding Named Set. Cannot map MUN to measure.");
                }
                munNode = (V5BoundModelIdentifier)factory.createNode(201116);
                munNode.setMetadata(measure);
            } else {
                level = hierarchy.getLevel(record.getLevelUniqueName());
                munNode = (V5BoundMemberUniqueName)factory.createNode(201117);
                ((V5BoundMemberUniqueName)munNode).setExternalMemberUniqueName(externalMUN);
                if (level == null && hierarchy.isParentChild()) {
                    level = (ILevel)ExpandEssbaseNamedSetMultiPartIdentifier.getLevelViaSecondaryV5Query((V5BoundMemberUniqueName)munNode, environment, hierarchy);
                }
                ((V5BoundMemberUniqueName)munNode).setLevel(level);
            }
            set.addChild(munNode);
        }
        node.exchange(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IMetadata getLevelViaSecondaryV5Query(V5BoundMemberUniqueName munNode, PlanningEnvironment environment, IHierarchy hierarchy) {
        IMember theMember;
        ILevel metaData = null;
        PlanningEnvironment subQueryEnvironment = V5SubQueryBuilder.createPlanningEnvironment((ExecutionEnvironment)environment.getExecutionEnvironment(), environment);
        ILevel tempLevel = hierarchy.getLevel(0);
        munNode.setLevel(tempLevel);
        V5QuerySet v5QuerySet = V5SubQueryBuilder.createSingleMemberQuery(munNode, subQueryEnvironment);
        PlannedV5QuerySet plannedQuery = QueryPlanner.getInstance().planQuery(v5QuerySet, subQueryEnvironment);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)subQueryEnvironment.getExecutionEnvironment();
        XDataContext dataContext = execEnv.pushDataContext();
        try {
            IHybridResultSet hybridResultSet = V5SubQueryBuilder.executeSubQuery(dataContext, plannedQuery);
            try {
                theMember = V5SubQueryBuilder.getMemberFromSubQuery(hybridResultSet);
            }
            finally {
                hybridResultSet.release();
            }
        }
        finally {
            execEnv.popDataContext(dataContext);
        }
        ILevel memberLevel = theMember.getLevel();
        metaData = hierarchy.getLevel(memberLevel.getIndex());
        return metaData;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        ICube cube;
        String providerCode;
        String calcType;
        XQETrace trace = environment.getTrace();
        boolean status = false;
        IMetadata metaData = ((V5BoundModelIdentifier)node).getMetadata();
        if (metaData == null) {
            this.traceNodeCondition(false, "Unable to replace bound object which is null.", trace);
            return false;
        }
        if (metaData.getObjectType() == MetadataType.CALCULATION && (calcType = ((ICalculation)metaData).getCalcType()).equals("namedSet") && ((INamedSet)metaData).getDimension() != null && DataSourceTypeEnum.isEssbase(providerCode = (cube = ((INamedSet)metaData).getDimension().getCube()).getModelDataSource().getInterface())) {
            status = true;
        }
        StringBuilder msgStr = new StringBuilder("The node is");
        String s1 = "a cube namedSet.";
        if (!status) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append(s1);
        } else {
            msgStr.append(" ");
            msgStr.append(s1);
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }
}

