/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FixEssbaseDateTimeValue
extends EssbaseTransformation {
    public static final String APPLIED = "isApplied";
    public static final String DATEFORMAT = "yyyy-mm-dd";

    public FixEssbaseDateTimeValue() {
        this.mName = "Drop time part in essbase.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1151};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        Value dateString = ((MDXDateTimeConstant)node).getConstantValue();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        Date convertedDate = null;
        try {
            convertedDate = dateFormat.parse(dateString.getString());
        }
        catch (ParseException ex) {
            XQEDebugLog.err.println("Parsing Date Error");
        }
        String reportDate = dateFormat.format(convertedDate);
        DateValue dtValue = DataValueFactory.createDateValue();
        dtValue.set(reportDate);
        ((MDXDateTimeConstant)node).setConstantValue(dtValue);
        node.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue(APPLIED);
        if (propValue != null) {
            isApplied = propValue;
        }
        if (isApplied) {
            this.traceNodeCondition(status, "The DateTime Constant value has already been resolved.", trace);
            return false;
        }
        status = true;
        this.traceNodeCondition(status, "The datetime constant exists.", trace);
        return status;
    }
}

