/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXExternalFunction;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ResolveDateComparison
extends EssbaseTransformation {
    public static final String APPLIED = "isApplied";
    public static final String DATEFORMAT = "yyyy-mm-dd";

    public ResolveDateComparison() {
        this.mName = "Resolve Date Type value comparison in essbase.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1070};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean isLOLAP = false;
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
        if (capabilities.isSupported("v5.useLocalOLAP") && !((MDXQuery)cogMDXQueryNode).getForceRemoteQueryProcessing()) {
            isLOLAP = true;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        if (isLOLAP) {
            CogMDXExternalFunction vbaFormat = (CogMDXExternalFunction)factory.createNode(1158);
            IXQEQueryNode property = node.getChild(0);
            property.insertParent(vbaFormat);
        } else {
            IXQEQueryNode value = node.getChild(1);
            value.detach();
            IXQEQueryNode toDateEx = factory.createNode(1169);
            IXQEQueryNode format = factory.createNode(1127);
            ((MDXStringConstant)format).setConstantValue(DATEFORMAT);
            toDateEx.addChild(format);
            if (value.getType() == 1151) {
                Value dateString = ((MDXDateTimeConstant)value).getConstantValue();
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
                Date convertedDate = null;
                try {
                    convertedDate = dateFormat.parse(dateString.getString());
                }
                catch (ParseException ex) {
                    XQEDebugLog.err.println("Parsing Date Error");
                }
                String reportDate = dateFormat.format(convertedDate);
                DateValue dtValue = DataValueFactory.createDateValue();
                dtValue.set(reportDate);
                ((MDXDateTimeConstant)value).setConstantValue(dtValue);
            }
            toDateEx.addChild(value);
            node.addChild(toDateEx);
        }
        node.setPropertyValue(APPLIED, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue(APPLIED);
        if (propValue != null) {
            isApplied = propValue;
        }
        if (isApplied) {
            this.traceNodeCondition(status, "The date comparison has already been resolved.", trace);
            return false;
        }
        int operatorType = ((MDXComparisonOperator)node).getOperatorType();
        switch (operatorType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (node.getChild(0).getType() != 1016 || !((CogMDXProperties)node.getChild(0)).isDateTimeProperty() || node.getChild(1).getType() != 1151 && node.getChild(1).getType() != 1162) break;
                status = true;
                break;
            }
        }
        this.traceNodeCondition(status, "The comparison of date type value exists.", trace);
        return status;
    }
}

