/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTopBottomFunction;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;

public class ResolveDefaultMemberInTopcountVE
extends EssbaseTransformation {
    public ResolveDefaultMemberInTopcountVE() {
        this.mName = "Resolve DefaultMember in a TOPCOUNT function value expression.";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1041};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] dms;
        XQENodeFactory factory = environment.getNodeFactory();
        IXQEQueryNode child = node.getChild(2);
        for (IXQEQueryNode dm : dms = child.getDescendantsOfType(1077, false)) {
            BaseHierarchy hierarchy = (BaseHierarchy)dm.getChild(0);
            IHierarchy metaHierarchy = hierarchy.getHierarchy();
            IMember metaRoot = metaHierarchy.getRootMember();
            IXQEQueryNode rm = factory.createNode(1067);
            ((BaseMember)rm).bind(metaRoot);
            dm.exchange(rm, false);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        IXQEQueryNode cogMDXQueryNode = node.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = ((MDXQuery)cogMDXQueryNode).getCapabilities();
        if (capabilities.isSupported("v5.useLocalOLAP") && !((MDXQuery)cogMDXQueryNode).getForceRemoteQueryProcessing()) {
            this.traceNodeCondition(false, "Essbase default member transformation not required. ", trace);
            return false;
        }
        if (((MDXTopBottomFunction)node).getOperatorType() == 1 && node.getNumberChildren() == 3) {
            IXQEQueryNode child = node.getChild(2);
            if (child.getType() == 1059 && child.getChild(0).getType() == 1069) {
                IXQEQueryNode[] dms = child.getDescendantsOfType(1077, false);
                if (dms.length > 0) {
                    status = true;
                    this.traceNodeCondition(status, "The DefaultMember exists.", trace);
                } else {
                    status = false;
                    this.traceNodeCondition(status, "The DefaultMember doesn't exists.", trace);
                }
            }
        } else {
            status = false;
        }
        return status;
    }
}

