/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCellProperties;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;

public class SetEssbaseDefaultCellProperties
extends EssbaseTransformation {
    public SetEssbaseDefaultCellProperties() {
        this.mName = "Set Essbase default cell properties on axis";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1002};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node;
        MDXCellProperties props = mdxQuery.getCellProperties();
        if (props.getCellPropertyCount() > 0) {
            this.traceNodeCondition(true, "Cell properties are set but Essbase does not support this.", trace);
            return true;
        }
        this.traceNodeCondition(true, "Cell properties are empty this is fine for Essbase.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        mdxQuery.clearCellProperties();
    }
}

