/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.essbase.EssbaseTransformation;
import java.util.Map;

public class SetEssbaseExternalCubeName
extends EssbaseTransformation {
    public SetEssbaseExternalCubeName() {
        this.mName = "Set Essbase cube name which is of the form [Catalog.Cube]";
        this.mPassNumbers = new int[]{2, 46};
        this.mTypes = new int[]{1007};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXFromCube fromCube = (MDXFromCube)node;
        if (fromCube.getPropertyValue("externalCubeName") == null) {
            this.traceNodeCondition(true, "Essbase external cube name must be set for Java native providers. ", trace);
            return true;
        }
        this.traceNodeCondition(false, "Essbase external cube name already set. ", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXFromCube fromCube = (MDXFromCube)node;
        IDataSource dataSource = fromCube.getCMDataSource();
        Map<String, Object> properties = dataSource.getMetadataProperties();
        String catalog = (String)properties.get("catalog");
        String cube = (String)properties.get("cube");
        StringBuilder essCubeName = new StringBuilder();
        essCubeName.append("[");
        essCubeName.append(catalog);
        essCubeName.append(".");
        essCubeName.append(cube);
        essCubeName.append("]");
        fromCube.setPropertyValue("externalCubeName", essCubeName.toString());
    }
}

