/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.essbase.direct;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.provider.essbase.direct.EssbaseDirectTransformation;
import java.util.List;

public class RollbackSetAliasForDescendantsFunc
extends EssbaseDirectTransformation {
    public RollbackSetAliasForDescendantsFunc() {
        this.mName = "Rollback Set Alias for Descendants Function.";
        this.mPassNumbers = new int[]{45};
        this.mTypes = new int[]{1015};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXSetAliasDefinition definition = ((MDXSetAliasReference)node).getDefinition();
        IXQEQueryNode parent = node.getParent();
        IXQEQueryNode definitionExpr = definition.getChild(0);
        IXQEQueryNode newChild = factory.deepCopyNode(definitionExpr);
        parent.exchangeChildNode(node, newChild);
        List<MDXSetAliasReference> saRefs = definition.getSetAliasRefs();
        saRefs.remove(node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXSetAliasDefinition definition = ((MDXSetAliasReference)node).getDefinition();
        if (definition.getNumberChildren() == 1 && definition.getChild(0).getType() == 1052) {
            boolean isRequired = false;
            MDXSetAliasReference aliasRef = (MDXSetAliasReference)node;
            Boolean propValue = (Boolean)aliasRef.getPropertyValue("required");
            if (propValue != null) {
                isRequired = propValue;
            }
            if (isRequired) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TemporarilyUnsupportedFeature, "Temporarily unsupported due to an Essbase bug when set alias is defined on a descendants function.");
            }
            status = true;
        }
        if (status) {
            this.traceNodeCondition(status, "The MDXSetAliasDefinition has Descendants function child.", trace);
        } else {
            this.traceNodeCondition(status, "The MDXSetAliasDefinition doesn't have Descendants function child.", trace);
        }
        return status;
    }
}

