/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;
import java.sql.Timestamp;

public final class FixMSASDateTimeValue
extends ProviderTransformation {
    private static final String[] PROVIDER_TYPES = new String[]{"YK", "M8", "M12", "M14", "M16", "M17", "M19", "MAZ", "XO", "X5", "X8"};
    static final String TRIMMING_DONE = "dateTimeValueTrimmed";

    public FixMSASDateTimeValue() {
        super(PROVIDER_TYPES);
        this.mName = "Fix msas dateTime value";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1151};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXDateTimeConstant dateTimeConst = (MDXDateTimeConstant)node;
        Value dateTimeValue = dateTimeConst.getConstantValue();
        Timestamp tsValue = dateTimeValue.getTimestamp();
        tsValue.setNanos(0);
        dateTimeValue.set(tsValue);
        ((MDXDateTimeConstant)node).setConstantValue(dateTimeValue);
        node.setPropertyValue(TRIMMING_DONE, Boolean.TRUE);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        node.throwOnInvalidChildCategories();
        if (!node.getParent().isOfCategory(1070)) {
            this.traceNodeCondition(false, "Transformation only needed for comparison on dateTime constant.", trace);
            return false;
        }
        String dateTimeTrimmed = TRIMMING_DONE;
        if (node.getPropertyValue(TRIMMING_DONE) != null) {
            this.traceNodeCondition(false, "Trimming of millisecond for msas dateTime already applied.", trace);
            return false;
        }
        MDXDateTimeConstant dateTimeConst = (MDXDateTimeConstant)node;
        Value dateTimeValue = dateTimeConst.getConstantValue();
        Timestamp tsValue = dateTimeValue.getTimestamp();
        if (tsValue.getNanos() == 0) {
            this.traceNodeCondition(false, "No nanos, no need to trim.", trace);
            return false;
        }
        this.traceNodeCondition(true, "MSAS dateTime value can't have millisecond part.", trace);
        return true;
    }
}

