/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXStringFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public final class RenameStringFunctions
extends ProviderTransformation {
    static final String[] PROVIDER_TYPES = new String[]{"YK", "M8", "M12", "M14", "M16", "M17", "M19", "MAZ", "X5", "XO", "X8"};

    public RenameStringFunctions() {
        super(PROVIDER_TYPES);
        this.mName = "Rename string functions for MSAS 2000 and MSAS 2005";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1149};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXStringFunction fn = (CogMDXStringFunction)node;
        int type = fn.getOperatorType();
        switch (type) {
            case 1: {
                fn.setOperatorMDX("VBA!UCASE");
                break;
            }
            case 2: {
                fn.setOperatorMDX("VBA!LCASE");
                break;
            }
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        String fnMDX = ((CogMDXStringFunction)node).getMDXTextName();
        if (!fnMDX.equals("LOWER") && !fnMDX.equals("UPPER")) {
            this.traceNodeCondition(false, "This string function does not need to be renamed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This string function must be renamed.", trace);
        return true;
    }
}

