/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;

public final class RenameYukonProperties
extends YukonTransformation {
    public RenameYukonProperties() {
        this.mName = "Rename properties for MSAS 2005";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BaseProperty prop = (BaseProperty)node.getChild(0);
        IQueryItem property = prop.getPropertyMetadata();
        if (property != null) {
            prop.setPropertyValue("externalName", "UNIQUE_NAME");
        } else {
            prop.setPropertyName("UNIQUE_NAME");
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (node.getChild(0).getType() != 1025) {
            this.traceNodeCondition(false, "The property is not a base property.", trace);
            return false;
        }
        String propName = ((BaseProperty)node.getChild(0)).getMDXName();
        if (!propName.equals("MEMBER_UNIQUE_NAME")) {
            this.traceNodeCondition(false, "The property is not one of the properties that must be renamed.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Property must be renamed.", trace);
        return true;
    }
}

