/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXTopBottomFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.util.ArrayUtil;

public final class ReplaceHeadWithTopCount
extends YukonTransformation {
    public ReplaceHeadWithTopCount() {
        this.mName = "Replace HEAD with TOPCOUNT for set alias.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1042};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXTopBottomFunction topcount = (MDXTopBottomFunction)factory.createNode(1041);
        topcount.setOperatorType(1);
        node.getParent().exchangeChildNode(node, topcount, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXHeadTailFunction head = (MDXHeadTailFunction)node;
        if (head.getType() == 1) {
            this.traceNodeCondition(false, "The target node is not a of type HEAD.", trace);
            return false;
        }
        if (head.getNumberChildren() != 2) {
            this.traceNodeCondition(false, "The target node does not have 2 children.", trace);
            return false;
        }
        IXQEQueryNode[] references = head.getChild(1).getDescendantsOfType(1015, true);
        if (references.length == 0) {
            this.traceNodeCondition(false, "The second child does not reference an MDXSetAliasReference node.", trace);
            return false;
        }
        Object[] definitions = head.getChild(0).getDescendantsOfType(1004, true);
        for (int i = 0; i < references.length; ++i) {
            MDXSetAliasReference ref = (MDXSetAliasReference)references[i];
            if (!ArrayUtil.contains(definitions, ref.getDefinition())) continue;
            this.traceNodeCondition(true, "The second child contains a set alias defined in the first child.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The second child does not contain a set alias defined in the first child.", trace);
        return false;
    }
}

