/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import java.util.List;

public final class CrossjoinSummarySetWithSlicerSet
extends YukonTransformation {
    public static final String TRANSFORMATION_APPLIED = "RemoveUnnecessaryMDFForAllowAutoexistsWithSlicerApplied";
    private static final String THE_TRANSFORMATION_IS_NOT_APPLICABLE = "The transformation is not applicable.";

    public CrossjoinSummarySetWithSlicerSet() {
        this.mName = "Crossjoin the summary set with the slicer set.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXSummaryFunction summaryFn = (MDXSummaryFunction)node;
        AbstractMDXSet summarySet = (AbstractMDXSet)summaryFn.getChild(0);
        MDXQuery mdxQueryNode = (MDXQuery)summaryFn.getAncestorOfType(1002);
        AbstractMDXNode dimLineChild = (AbstractMDXNode)mdxQueryNode.getDimensionLine().getChild(0);
        if (dimLineChild.getType() != 1030 && summarySet.getHierarchyInfo().projectsHierarchy(dimLineChild.getHierarchyInfo().getProjectedHierarchy(0))) {
            summaryFn.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
            return;
        }
        MDXHierInfo sumaryHierInfo = summarySet.getHierarchyInfo();
        AbstractMDXSet setToCrossjoin = null;
        setToCrossjoin = this.createSetToCrossjoin(mdxQueryNode, environment, dimLineChild, sumaryHierInfo, setToCrossjoin);
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)factory.createNode(1030);
        summaryFn.exchangeChildNode(summarySet, mdxCrossjoin);
        mdxCrossjoin.addChild(summarySet);
        mdxCrossjoin.addChild(setToCrossjoin);
        summaryFn.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    public AbstractMDXSet createSetToCrossjoin(MDXQuery mdxQueryNode, PlanningEnvironment environment, AbstractMDXNode currDimLineDescendant, MDXHierInfo sumaryHierInfo, AbstractMDXSet setToCrossjoin) {
        XQENodeFactory factory = environment.getNodeFactory();
        boolean hiearchyIsNotPresent = true;
        if (currDimLineDescendant.getType() == 1030) {
            AbstractMDXSet child0 = (AbstractMDXSet)currDimLineDescendant.getChild(0);
            IHierarchy hier0 = child0.getHierarchyInfo().getProjectedHierarchy(0);
            boolean bl = hiearchyIsNotPresent = !sumaryHierInfo.projectsHierarchy(hier0);
            if (hiearchyIsNotPresent) {
                if (setToCrossjoin == null) {
                    setToCrossjoin = (AbstractMDXSet)factory.deepCopyNode(child0);
                } else {
                    MDXCrossjoin crossjoin = (MDXCrossjoin)factory.createNode(1030);
                    crossjoin.addChild(setToCrossjoin);
                    crossjoin.addChild((AbstractMDXSet)factory.deepCopyNode(child0));
                    setToCrossjoin = crossjoin;
                }
            }
            setToCrossjoin = this.createSetToCrossjoin(mdxQueryNode, environment, (AbstractMDXSet)currDimLineDescendant.getChild(1), sumaryHierInfo, setToCrossjoin);
        } else if (setToCrossjoin == null) {
            if (mdxQueryNode.getDimensionLine().getChild(0).isOfCategory(1021)) {
                setToCrossjoin = (AbstractMDXSet)factory.deepCopyNode(currDimLineDescendant);
            } else {
                setToCrossjoin = (MDXSet)factory.createNode(1039);
                setToCrossjoin.addChild(factory.deepCopyNode(currDimLineDescendant));
            }
        } else {
            MDXCrossjoin crossjoin = (MDXCrossjoin)factory.createNode(1030);
            crossjoin.addChild(setToCrossjoin);
            if (mdxQueryNode.getDimensionLine().getChild(0).isOfCategory(1021)) {
                crossjoin.addChild((AbstractMDXSet)factory.deepCopyNode(currDimLineDescendant));
            } else {
                MDXSet set = (MDXSet)factory.createNode(1039);
                set.addChild(factory.deepCopyNode(currDimLineDescendant));
                crossjoin.addChild(set);
            }
            setToCrossjoin = crossjoin;
        }
        return setToCrossjoin;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied.", trace);
            return false;
        }
        boolean allowAutoExistsInSlicer = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("queryPlanning.AllowAutoexistsWithSlicer[@enabled]", false);
        if (!allowAutoExistsInSlicer) {
            this.traceNodeCondition(false, "AllowAutoexistsWithSlicer is not enable.", trace);
            return false;
        }
        MDXSummaryFunction summaryFn = (MDXSummaryFunction)node;
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)summaryFn.getAncestorOfType(1005);
        if (calcDef == null || !calcDef.getPrefix().equals("_RS")) {
            this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return false;
        }
        MDXQuery mdxQueryNode = (MDXQuery)summaryFn.getAncestorOfType(1002);
        if (mdxQueryNode.getFirstChildByType(1142) == null && !summaryFn.getYukonHierarchyRelationshipsApplied()) {
            this.traceNodeCondition(false, "The MDXQuery does not have TNodeYukonImplicitMembers node.", trace);
            return false;
        }
        if (!summaryFn.getYukonHierarchyRelationshipsApplied()) {
            this.traceNodeCondition(false, "The MDXSummaryFunction has not been updated for hierarchy relationships.", trace);
            return false;
        }
        if (mdxQueryNode.getDimensionLine() == null) {
            this.traceNodeCondition(false, "There is no dimesion line.", trace);
            return false;
        }
        AbstractMDXSet summarySet = (AbstractMDXSet)summaryFn.getChild(0);
        if (summarySet.getType() == 1143) {
            this.traceNodeCondition(false, "AddImplicitMemberToSummarySet is pending.", trace);
            return false;
        }
        try {
            List<IHierarchy> summarySetHierarchies = summarySet.getHierarchyInfo().getProjectedHierarchies();
            MDXHierInfo dimLineHierInfo = mdxQueryNode.getDimensionLine().getHierarchyInfo();
            for (IHierarchy summarySetHierarchy : summarySetHierarchies) {
                if (dimLineHierInfo.projectsHierarchy(summarySetHierarchy) || !dimLineHierInfo.projectsSameDimensionDiffHierarchy(summarySetHierarchy)) continue;
                this.traceNodeCondition(true, "The transformation is applicable.", trace);
                return true;
            }
        }
        finally {
            this.traceNodeCondition(false, THE_TRANSFORMATION_IS_NOT_APPLICABLE, trace);
            return false;
        }
        {
        }
    }
}

