/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.TNodeYukonImplicitMembers;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.CalcMemberReferencePrefixes;
import java.util.ArrayList;
import java.util.List;

public final class RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer
extends YukonTransformation {
    public static final String TRANSFORMATION_APPLIED = "RemoveUnnecessaryMDFForAllowAutoexistsWithSlicerApplied";

    public RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer() {
        this.mName = "Remove unnecessary MDF for AllowAutoexistsWithSlicer.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{1142};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        TNodeYukonImplicitMembers tNode = (TNodeYukonImplicitMembers)node;
        MDXQuery mdxQueryNode = (MDXQuery)tNode.getAncestorOfType(1002);
        ArrayList<List<MDXCalculatedMemberReference>> listOfUsefulMDFCalcLists = new ArrayList<List<MDXCalculatedMemberReference>>();
        ArrayList<MDXCalculatedMemberReference> listOfTopMDFInTNode = new ArrayList<MDXCalculatedMemberReference>();
        for (int i = 0; i < tNode.getNumberChildren(); ++i) {
            AbstractMDXMember member = (AbstractMDXMember)tNode.getChild(i);
            if (!CalcMemberReferencePrefixes.isMDF(member)) continue;
            MDXCalculatedMemberReference mdfCalc = (MDXCalculatedMemberReference)member;
            if (this.isDimLineProjectsSameHierarchies(mdfCalc, mdxQueryNode)) {
                this.removeMDFCalc(mdfCalc, mdxQueryNode);
                continue;
            }
            ArrayList mdfCalcList = new ArrayList();
            listOfUsefulMDFCalcLists.add(mdfCalcList);
            RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.collectMDFWichDimensionAndHierarchyAreInSlicer(mdfCalc, mdxQueryNode, tNode, listOfTopMDFInTNode, listOfUsefulMDFCalcLists);
        }
        IXQEQueryNode[] tNodeMembers = tNode.getChildren();
        int numOfCalc = 0;
        int tNodeMemberIdx = -1;
        for (IXQEQueryNode tNodeMember : tNodeMembers) {
            List currMDFCalcList;
            if (CalcMemberReferencePrefixes.isMDF((AbstractMDXMember)tNodeMember)) {
                ++numOfCalc;
            }
            if (!listOfTopMDFInTNode.contains(tNodeMember)) continue;
            if ((currMDFCalcList = (List)listOfUsefulMDFCalcLists.get(++tNodeMemberIdx)).isEmpty()) {
                tNodeMember.detach();
                continue;
            }
            int i = 0;
            RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.fixMDF((MDXCalculatedMemberReference)tNodeMember, currMDFCalcList, i, mdxQueryNode);
        }
        if (numOfCalc == 0 && tNode.getContainsSlicerCalcMember()) {
            tNode.setContainsSlicerCalcMember(false);
        }
        if (tNode.getNumberChildren() == 0) {
            tNode.detach();
        }
        tNode.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
    }

    public static void fixMDF(MDXCalculatedMemberReference targetMDF, List<MDXCalculatedMemberReference> usefulMDFCalcList, int usefulMDFPos, MDXQuery mdxQueryNode) {
        MDXCalculatedMemberReference outerMDF = usefulMDFCalcList.get(usefulMDFPos);
        MDXCalculatedMemberDefinition outerMDFDef = outerMDF.getDefinition();
        MDXCalculatedMemberReference innerMDF = null;
        int numOfMDFs = usefulMDFCalcList.size();
        if (numOfMDFs > usefulMDFPos + 1) {
            innerMDF = usefulMDFCalcList.get(usefulMDFPos + 1);
        }
        boolean needReplacement = RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.foundSameDimensionDifferentHierarchyInDimLine(targetMDF, mdxQueryNode);
        if (outerMDFDef.getChild(0).getType() == 1059) {
            if (needReplacement) {
                targetMDF.getParent().exchangeChildNode(targetMDF, outerMDF);
            } else if (targetMDF.getDefinition().getChild(0).getType() == 1060 && targetMDF.getDefinition().getChild(0).getNumberChildren() == 1) {
                targetMDF.getDefinition().getChild(0).addChild(outerMDF);
            }
            MDXCalculatedMemberReference nestedMember = (MDXCalculatedMemberReference)outerMDFDef.getChild(0).getChild(0).getFirstChildByType(1013);
            if (nestedMember != null && CalcMemberReferencePrefixes.isMDF(nestedMember) && numOfMDFs > usefulMDFPos + 1) {
                RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.fixMDF(nestedMember, usefulMDFCalcList, usefulMDFPos + 1, mdxQueryNode);
            } else if (nestedMember != null && CalcMemberReferencePrefixes.isMDF(nestedMember) && numOfMDFs == usefulMDFPos + 1 && RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.foundSameDimensionDifferentHierarchyInDimLine(nestedMember, mdxQueryNode)) {
                nestedMember.detach();
            }
        } else if (outerMDFDef.getChild(0).getType() == 1060) {
            IXQEQueryNode summSecondChild;
            if (outerMDFDef.getChild(0).getNumberChildren() == 2 && (summSecondChild = outerMDFDef.getChild(0).getChild(1)).getType() == 1059 && summSecondChild.getChild(0).getType() == 1069) {
                MDXCalculatedMemberReference nestedCalc = (MDXCalculatedMemberReference)summSecondChild.getChild(0).getFirstChildByType(1013);
                if (nestedCalc != null) {
                    boolean nestedNeedReplacement = false;
                    nestedNeedReplacement = CalcMemberReferencePrefixes.isMDF(nestedCalc) ? !usefulMDFCalcList.contains(nestedCalc) : RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.foundSameDimensionDifferentHierarchyInDimLine(nestedCalc, mdxQueryNode);
                    if (nestedNeedReplacement) {
                        if (innerMDF != null) {
                            nestedCalc.getParent().getParent().exchangeChildNode(nestedCalc, innerMDF);
                        } else {
                            nestedCalc.getParent().getParent().detach();
                        }
                    }
                    if (nestedCalc.getType() == 1013 && CalcMemberReferencePrefixes.isMDF(nestedCalc) && numOfMDFs > usefulMDFPos + 2) {
                        RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.fixMDF(nestedCalc, usefulMDFCalcList, usefulMDFPos + 1, mdxQueryNode);
                    }
                } else {
                    AbstractMDXMember tupleMember = (AbstractMDXMember)summSecondChild.getChild(0).getChild(0);
                    boolean nestedNeedReplacement = RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.foundSameDimensionDifferentHierarchyInDimLine(tupleMember, mdxQueryNode);
                    if (nestedNeedReplacement) {
                        if (innerMDF != null) {
                            tupleMember.getParent().getParent().exchangeChildNode(nestedCalc, innerMDF);
                        } else {
                            tupleMember.getParent().getParent().detach();
                        }
                    }
                }
            }
            if (needReplacement) {
                targetMDF.getParent().exchangeChildNode(targetMDF, outerMDF);
            } else if (innerMDF != null && outerMDFDef.getChild(0).getNumberChildren() == 1) {
                outerMDFDef.getChild(0).addChild(innerMDF);
            }
        }
    }

    public boolean isDimLineProjectsSameHierarchies(MDXCalculatedMemberReference mdfCalc, MDXQuery mdxQueryNode) {
        MDXHierInfo dimensionLineHierInfo = mdxQueryNode.getDimensionLine().getHierarchyInfo();
        MDXHierInfo calcHierInfo = mdfCalc.getHierarchyInfo();
        return dimensionLineHierInfo.projectsHierarchies(calcHierInfo);
    }

    public void removeMDFCalc(MDXCalculatedMemberReference mdfCalc, MDXQuery mdxQueryNode) {
        MDXCalculatedMemberDefinition mdfCalDefinition = mdfCalc.getDefinition();
        mdfCalc.detach();
        List<AbstractMDXNode> descenRefs = mdfCalDefinition.getDescendantsOfCategory(1013, true, true, true, true, true);
        for (int i = 0; i < descenRefs.size(); ++i) {
            MDXCalculatedMemberReference mdRef = (MDXCalculatedMemberReference)descenRefs.get(i);
            MDXCalculatedMemberDefinition childDef = mdRef.getDefinition();
            if (childDef == null || childDef.getCalcMemberRefs().size() != 1) continue;
            childDef.detach();
        }
        if (!mdxQueryNode.isDefinitionReferenced(mdfCalDefinition)) {
            mdfCalDefinition.detach();
        }
    }

    public static void collectMDFWichDimensionAndHierarchyAreInSlicer(MDXCalculatedMemberReference mdfCalc, MDXQuery mdxQueryNode, TNodeYukonImplicitMembers tNode, List<MDXCalculatedMemberReference> listOfTopMDFInTNode, List<List<MDXCalculatedMemberReference>> listOfUsefulMDFCalcLists) {
        MDXCalculatedMemberReference nestedMDFCalc;
        IXQEQueryNode summSecondChild;
        MDXCalculatedMemberDefinition mdfDefinition;
        boolean removeMDFFromTNode;
        IXQEQueryNode[] tNodeCalcs;
        for (IXQEQueryNode tNodeCalc : tNodeCalcs = tNode.getChildrenOfType(1013)) {
            if (tNodeCalc != mdfCalc) continue;
            listOfTopMDFInTNode.add(mdfCalc);
            break;
        }
        if (!(removeMDFFromTNode = RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.foundSameDimensionDifferentHierarchyInDimLine(mdfCalc, mdxQueryNode))) {
            listOfUsefulMDFCalcLists.get(listOfUsefulMDFCalcLists.size() - 1).add(mdfCalc);
        }
        if ((mdfDefinition = mdfCalc.getDefinition()).getChild(0).getType() == 1059 && mdfDefinition.getChild(0).getChild(0).getType() == 1069) {
            MDXCalculatedMemberReference nestedMDFCalc2 = (MDXCalculatedMemberReference)mdfDefinition.getChild(0).getChild(0).getFirstChildByType(1013);
            if (nestedMDFCalc2 != null && CalcMemberReferencePrefixes.isMDF(nestedMDFCalc2)) {
                RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.collectMDFWichDimensionAndHierarchyAreInSlicer(nestedMDFCalc2, mdxQueryNode, tNode, listOfTopMDFInTNode, listOfUsefulMDFCalcLists);
            }
        } else if (mdfDefinition.getChild(0).getType() == 1060 && mdfDefinition.getChild(0).getNumberChildren() == 2 && (summSecondChild = mdfDefinition.getChild(0).getChild(1)).getType() == 1059 && summSecondChild.getChild(0).getType() == 1069 && (nestedMDFCalc = (MDXCalculatedMemberReference)summSecondChild.getChild(0).getFirstChildByType(1013)) != null && CalcMemberReferencePrefixes.isMDF(nestedMDFCalc)) {
            RemoveUnnecessaryMDFForAllowAutoexistsWithSlicer.collectMDFWichDimensionAndHierarchyAreInSlicer(nestedMDFCalc, mdxQueryNode, tNode, listOfTopMDFInTNode, listOfUsefulMDFCalcLists);
        }
    }

    public static boolean foundSameDimensionDifferentHierarchyInDimLine(AbstractMDXMember member, MDXQuery mdxQueryNode) {
        boolean result = false;
        List<IHierarchy> dimensionLineHiers = mdxQueryNode.getDimensionLine().getHierarchyInfo().getProjectedHierarchies();
        for (IHierarchy dimensionLineHier : dimensionLineHiers) {
            MDXEdge[] edges;
            MDXCalculatedMemberDefinition ancestorDef;
            IHierarchy memberHier = member.getHierarchy();
            boolean bl = result = !memberHier.equals(dimensionLineHier) && memberHier.getDimension().equals(dimensionLineHier.getDimension());
            if (result) {
                return result;
            }
            if (!memberHier.equals(dimensionLineHier) || (ancestorDef = (MDXCalculatedMemberDefinition)member.getAncestorOfType(1005)) == null || !ancestorDef.getPrefix().equals("_MDF")) continue;
            for (MDXEdge edge : edges = mdxQueryNode.getEdges()) {
                MDXHierInfo edgeHierInfo = edge.getHierarchyInfo();
                List<IHierarchy> edgeHiers = edgeHierInfo.getProjectedHierarchies();
                for (IHierarchy edgeHier : edgeHiers) {
                    result = !memberHier.equals(edgeHier) && memberHier.getDimension().equals(edgeHier.getDimension());
                    if (!result) continue;
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(TRANSFORMATION_APPLIED) == Boolean.TRUE) {
            this.traceNodeCondition(false, "The transformation was already applied.", trace);
            return false;
        }
        boolean allowAutoExistsInSlicer = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("queryPlanning.AllowAutoexistsWithSlicer[@enabled]", false);
        if (!allowAutoExistsInSlicer) {
            this.traceNodeCondition(false, "AllowAutoexistsWithSlicer is not enable.", trace);
            return false;
        }
        TNodeYukonImplicitMembers tNode = (TNodeYukonImplicitMembers)node;
        MDXQuery mdxQueryNode = (MDXQuery)tNode.getAncestorOfType(1002);
        if (mdxQueryNode.getDimensionLine() == null) {
            this.traceNodeCondition(false, "There is no dimension line.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation is applicable.", trace);
        return true;
    }
}

