/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXTuple;
import com.cognos.xqe.ast.olap.MDXValue;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;

public final class ReplaceRootMemberWithCalculatedMember
extends YukonTransformation {
    public ReplaceRootMemberWithCalculatedMember() {
        this.mName = "Add Multiple Hierarchy Implicit Member To Context.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{1067};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        BaseMember member = (BaseMember)factory.copyNode(node);
        MDXValue value = (MDXValue)factory.createNode(1059);
        MDXTuple tuple = (MDXTuple)factory.createNode(1069);
        value.addChild(tuple);
        tuple.addChild(member);
        IHierarchy hierarchy = member.getHierarchy();
        MDXCalculatedMemberReference ref = MDXBuilder.buildMDXCalculatedMemberReference(factory, mdxQuery, hierarchy, "_YK", value, SolveOrderUtil.getMemberSolveOrder());
        node.getParent().exchangeChildNode(node, ref);
        ref.setReplacedRootMember((BaseMember)node);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = new StringBuilder();
        boolean result = ReplaceRootMemberWithCalculatedMember.nodeCondition(node, traceMsg);
        this.traceNodeCondition(result, traceMsg.toString(), trace);
        return result;
    }

    public static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        BaseMember member = (BaseMember)node;
        if (!member.getLevel().isRootLevel()) {
            if (traceMsg != null) {
                traceMsg.append("The member is not a root member.");
            }
            return false;
        }
        MDXEdge edge = (MDXEdge)member.getAncestorOfType(1006);
        if (edge == null) {
            if (traceMsg != null) {
                traceMsg.append("The member is not a descendant on an MDXEdge node.");
            }
            return false;
        }
        if (!edge.isProjectedDescendant(member)) {
            if (traceMsg != null) {
                traceMsg.append("The member is not projected on an edge.");
            }
            return false;
        }
        MDXHierInfo hierInfo = edge.getHierarchyInfo();
        hierInfo.removeHierarchiesFromOtherDimensions(member.getHierarchy().getDimension());
        if (hierInfo.getNumProjectedHierarchies() <= 1) {
            if (traceMsg != null) {
                traceMsg.append("There are no other hierarchies from the same dimension as this BaseMember projected on the edge.");
            }
            return false;
        }
        String rootMUN = null;
        if (member.getHierarchy().getRootMember() != null) {
            rootMUN = member.getHierarchy().getRootMember().getUniqueName();
        }
        if (!member.getExternalName().equals(rootMUN)) {
            if (traceMsg != null) {
                traceMsg.append("The member is not the root member of the hierarchy.");
            }
            return false;
        }
        if (traceMsg != null) {
            traceMsg.append("The member must be converted to a calculated member.");
        }
        return true;
    }
}

