/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.msas.msas2005.multihier.todeprecate;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.msas.msas2005.YukonTransformation;
import com.cognos.xqe.transformation.olap.util.BreakApartUnionForCogMDXGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ExtractContextFromCalculatedMember
extends YukonTransformation {
    public ExtractContextFromCalculatedMember() {
        this.mName = "Extract Context From Calculated Member.";
        this.mPassNumbers = new int[]{43};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        AbstractMDXSet parent = (AbstractMDXSet)calcRef.getAncestorOfTypes(new int[]{1030, 1057});
        if (BreakApartUnionForCogMDXGroup.canBreakApartUnionForCalculatedMember(calcRef)) {
            IXQEQueryNode tNode = factory.createNode(1153);
            parent.insertParent(tNode);
            environment.enableLockNodeQueryPlanning(1153);
            return;
        }
        IXQEQueryNode tNodeCalcContext = factory.createNode(1152);
        ArrayList<BaseMember> context = new ArrayList<BaseMember>();
        this.extractContext(calcRef, calcRef.getHierarchy(), context);
        AbstractMDXSet contextSet = (AbstractMDXSet)factory.createNode(1039);
        Iterator it = context.iterator();
        while (it.hasNext()) {
            contextSet.addChild(factory.copyNode((IXQEQueryNode)it.next()));
        }
        parent.getChild(1).insertParent(tNodeCalcContext);
        tNodeCalcContext.addChild(contextSet);
    }

    private boolean isAnotherHierarchyNestedBelowCalc(MDXCalculatedMemberReference calcRef) {
        AbstractMDXSet parent = (AbstractMDXSet)calcRef.getAncestorOfTypes(new int[]{1030, 1057});
        if (parent == null) {
            return false;
        }
        if (!((AbstractMDXSet)parent.getChild(0)).isDescendantNode(calcRef, false, true, true, false, true)) {
            return false;
        }
        AbstractMDXSet secondChild = (AbstractMDXSet)parent.getChild(1);
        MDXHierInfo hierInfo = secondChild.getHierarchyInfo();
        return hierInfo.projectsSameDimensionDiffHierarchy(calcRef.getHierarchy());
    }

    private boolean extractContext(IXQEQueryNode node, IHierarchy hierarchy, List<BaseMember> context) {
        if (node.isOfCategory(1022) && !((AbstractMDXMember)node).getHierarchy().equals(hierarchy)) {
            return true;
        }
        switch (node.getType()) {
            case 1067: {
                if (hierarchy.equals(((BaseMember)node).getHierarchy())) {
                    context.add((BaseMember)node);
                }
                return true;
            }
            case 1039: 
            case 1069: 
            case 1070: 
            case 1084: {
                for (int i = 0; i < node.getNumberChildren(); ++i) {
                    if (this.extractContext(node.getChild(i), hierarchy, context)) continue;
                    return false;
                }
                return true;
            }
            case 1059: 
            case 1060: 
            case 1144: {
                return this.extractContext(node.getChild(0), hierarchy, context);
            }
            case 1013: {
                return this.extractContext(((MDXCalculatedMemberReference)node).getDefinition().getChild(0), hierarchy, context);
            }
            case 1100: {
                if (node.getNumberChildren() <= 2) {
                    return false;
                }
                return this.extractContext(node.getChild(2), hierarchy, context);
            }
            case 1085: {
                return this.extractContext(node.getChild(0), hierarchy, context) || this.extractContext(node.getChild(1), hierarchy, context);
            }
            case 1064: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The node does not have an ancestor MDXQuery node.", trace);
            return false;
        }
        AbstractMDXSet parent = (AbstractMDXSet)node.getAncestorOfTypes(new int[]{1030, 1057});
        if (parent != null && parent.getChild(1).getType() == 1152) {
            this.traceNodeCondition(false, "Context already extracted.", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)node.getAncestorOfType(1006);
        if (edge == null || !edge.isProjectedDescendant((AbstractMDXNode)node)) {
            this.traceNodeCondition(false, "The node is not projected under an MDXEdge node.", trace);
            return false;
        }
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXHierInfo edgeHierInfo = edge.getHierarchyInfo();
        if (!edgeHierInfo.projectsSameDimensionDiffHierarchy(calcRef.getHierarchy())) {
            this.traceNodeCondition(false, "The MDXEdge node does not project multiple hierarchies from the same dimension as this node.", trace);
            return false;
        }
        if (!this.isAnotherHierarchyNestedBelowCalc(calcRef)) {
            this.traceNodeCondition(false, "Another hierarchy from the same dimension is not nested below this node.", trace);
            return false;
        }
        ArrayList<BaseMember> context = new ArrayList<BaseMember>();
        if (!this.extractContext(calcRef, calcRef.getHierarchy(), context) || context.isEmpty()) {
            this.traceNodeCondition(false, "Unable to extract explicit context from the calculated member.", trace);
            return false;
        }
        for (BaseMember baseMember : context) {
            if (!baseMember.getLevel().isRootLevel()) continue;
            this.traceNodeCondition(false, "One of the context members is a root member.", trace);
            return false;
        }
        if (calcRef.getParent().getType() == 1039 && calcRef.getParent().getNumberChildren() > 1) {
            if (BreakApartUnionForCogMDXGroup.canBreakApartUnionForCalculatedMember(calcRef)) {
                this.traceNodeCondition(true, "Need to break apart the parent MDXUnion or MDXSet before context can be added.", trace);
                return true;
            }
            node.throwInternalError("Unable to add context from calculation when node is not first child of CogMDXGroup node.");
            return true;
        }
        this.traceNodeCondition(true, "Need to extract the explicit context from the calculated member for the nested hierarchy.", trace);
        return true;
    }
}

