/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.powercube;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.ProviderTransformation;

public class RetrieveQueryDashboardHint
extends ProviderTransformation {
    public static final String APPLIED = "RetrieveQueryDashboardHintApplied";

    public RetrieveQueryDashboardHint() {
        super("PC");
        this.mName = "Retrieve the dashboard query hint and make sure it's enabled for Powercube V5.";
        this.mPassNumbers = new int[]{41};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        throw new XQERuntimeException(XQEMessageKeys.PLN_PowercubesNotSupported);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        if (RetrieveQueryDashboardHint.isPreviouslyApplied(node)) {
            this.traceNodeCondition(false, "The transformation has been applied.", trace);
            return false;
        }
        node.setPropertyValue(APPLIED, Boolean.TRUE);
        MDXQuery mdxQuery = (MDXQuery)node;
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (capabilities.isSupported("v5.dashboard.queryhint.ignore")) {
            this.traceQueryCondition(false, "The provider property file marked to ignore the the dashboard query hint.", trace);
            return false;
        }
        V5Query v5Query = this.getV5Query(node);
        if (v5Query == null) {
            this.traceQueryCondition(false, "Can't find V5Query.", trace);
            return false;
        }
        return this.checkDashboardQueryHint(trace, v5Query);
    }

    private boolean checkDashboardQueryHint(XQETrace trace, V5Query v5Query) {
        String dashboardHint = (String)v5Query.getPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName());
        if (dashboardHint == null) {
            this.traceQueryCondition(true, "The V5Query does not have a dashboard hint specified.", trace);
            return true;
        }
        if ("true".equals(dashboardHint)) {
            this.traceQueryCondition(false, "The V5Query has a dashboard hint of true specified.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Check the query hint dashboard.", trace);
        return true;
    }

    private static boolean isPreviouslyApplied(IXQEQueryNode node) {
        boolean isApplied = false;
        Boolean propValue = (Boolean)node.getPropertyValue(APPLIED);
        if (propValue != null) {
            isApplied = propValue;
        }
        return isApplied;
    }

    protected V5Query getV5Query(IXQEQueryNode node) {
        MDXQuery mdxQuery = (MDXQuery)node;
        String refQueryName = mdxQuery.getRefQueryProperty();
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        return v5QuerySet.getV5Query(refQueryName);
    }
}

