/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.powercube;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.powercube.PowerCubeTransformation;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;

public final class SetPowerCubeCachingId
extends PowerCubeTransformation {
    public static final String PROPERTY_CACHING_ID = "cachingId";

    public SetPowerCubeCachingId() {
        this.mName = "Add caching id for some set and aggregate functions.";
        this.mPassNumbers = new int[]{52};
        this.mTypes = new int[]{1040, 1048, 1030, 1052, 1053, 1058, 1041, 1147, 1033, 1038, 1057, 1032, 1042, 1060, 1087, 1100};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IXQEQueryNode[] nodesWithSameType = mdxQuery.getDescendantsOfType(node.getType(), true);
        ArrayList<IXQEQueryNode> nodesWithCachingId = new ArrayList<IXQEQueryNode>();
        for (IXQEQueryNode child : nodesWithSameType) {
            int cachingId = 0;
            boolean found = false;
            for (IXQEQueryNode cachingIdNode : nodesWithCachingId) {
                if (!child.isSameExpression(cachingIdNode, false)) continue;
                cachingId = (Integer)cachingIdNode.getPropertyValue(PROPERTY_CACHING_ID);
                child.setPropertyValue(PROPERTY_CACHING_ID, XQEIntegerPool.getInteger(cachingId));
                found = true;
                break;
            }
            if (found) continue;
            cachingId = mdxQuery.getNextCachingId();
            child.setPropertyValue(PROPERTY_CACHING_ID, XQEIntegerPool.getInteger(cachingId));
            nodesWithCachingId.add(child);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            this.traceQueryCondition(false, "Caching Id is only needed for PC and TM1.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The mdxQuery is null", trace);
            return false;
        }
        if (node.getPropertyValue(PROPERTY_CACHING_ID) != null) {
            this.traceNodeCondition(false, "The caching id has already been applied", trace);
            return false;
        }
        this.traceNodeCondition(true, "The node is a set or aggregate that should apply the caching id.", trace);
        return true;
    }
}

