/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.powercube;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.powercube.PowerCubeTransformation;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;

public class SetPowerCubeCalculatedMemberNameDQ
extends PowerCubeTransformation {
    private static final String PROP_HIERARCHY = "hierarchy";
    public static final String MSG_ERROR_PARSING_POWERCUBE_UNIQUE_NAME = "Error parsing PowerCube unique name. ";
    public static final String TR_APPLIED = "appliedSetPCCalcMemName";

    public SetPowerCubeCalculatedMemberNameDQ() {
        this.mName = "Set PowerCube calculated measure name which should be [<MeasureDimExternalName>].[<CalcName>]";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1005};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "Not using LOLAP to process this query, SetPowerCubeCalculatedMemberName should be applied instead.", trace);
            return false;
        }
        MDXCalculatedMemberDefinition calc = (MDXCalculatedMemberDefinition)node;
        IHierarchy hierarchy = (IHierarchy)calc.getPropertyValue(PROP_HIERARCHY);
        if (hierarchy == null) {
            this.traceNodeCondition(false, "PowerCube calculated member has no 'hierarchy' property.", trace);
            return false;
        }
        String member = calc.getCustomUniqueName();
        if (member == null) {
            this.traceNodeCondition(false, "PowerCube calculated member has no 'member' property.", trace);
            return false;
        }
        if (node.getPropertyValue(TR_APPLIED) != null) {
            return false;
        }
        this.traceNodeCondition(true, "PowerCube calculated member name will be translated.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition calc = (MDXCalculatedMemberDefinition)node;
        String member = calc.getCustomUniqueName();
        IHierarchy hierarchy = (IHierarchy)calc.getPropertyValue(PROP_HIERARCHY);
        IDimension dimension = hierarchy.getDimension();
        StringBuffer un = new StringBuffer(dimension.getUniqueName());
        un.append(".");
        String calcName = null;
        try {
            String[] parts = UniqueNameParser.parse(member);
            calcName = parts[parts.length - 1];
        }
        catch (UniqueNameParserException e) {
            XQEDebugLog.err.println(MSG_ERROR_PARSING_POWERCUBE_UNIQUE_NAME + member);
            return;
        }
        un.append("[" + calcName + "]");
        calc.setCustomUniqueName(un.toString());
        node.setPropertyValue(TR_APPLIED, true);
    }
}

