/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.powercube;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.provider.powercube.PowerCubeTransformation;

public class SetPowerCubeMeasureHierarchy
extends PowerCubeTransformation {
    public SetPowerCubeMeasureHierarchy() {
        this.mName = "Set PowerCube measure hierarchy name which should be [<MeasureDimExternalName>].[]";
        this.mPassNumbers = new int[]{2, 46, 52};
        this.mTypes = new int[]{1073};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getUseLocalQueryProcessing()) {
            this.traceNodeCondition(false, "Using LOLAP to process this query.", trace);
            return false;
        }
        BaseHierarchy bh = (BaseHierarchy)node;
        IHierarchy hierarchy = bh.getHierarchy();
        IDimension dimension = hierarchy.getDimension();
        if (!dimension.isMeasuresDimension()) {
            this.traceNodeCondition(false, "PowerCube hierarchy is not a measure hierarchy.", trace);
            return false;
        }
        String externalName = (String)bh.getPropertyValue("externalName");
        if (externalName != null) {
            this.traceNodeCondition(false, "PowerCube hierarchy already has an ExternalName.", trace);
            return false;
        }
        this.traceNodeCondition(true, "PowerCube hierarchy ExternalName will be set.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        BaseHierarchy bh = (BaseHierarchy)node;
        IHierarchy hierarchy = bh.getHierarchy();
        IDimension dimension = hierarchy.getDimension();
        String dimensionName = dimension.getUniqueName();
        String hierarchyName = dimensionName + "." + "[" + "]";
        bh.setPropertyValue("externalName", hierarchyName);
    }
}

