/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.provider.sapbw;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.provider.sapbw.SAPBWTransformation;

public class ConvertDistanceToLevelForSAPAncDescFunc
extends SAPBWTransformation {
    public ConvertDistanceToLevelForSAPAncDescFunc() {
        this.mName = "Convert the distance to level in ancestor or descendants function.";
        this.mPassNumbers = new int[]{31, 46};
        this.mTypes = new int[]{1043, 1052};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IDataSourceCapabilities capabilities = mdxQuery.getCapabilities();
        if (!capabilities.isSupported("convertIndexToLevelInAncDescFunc")) {
            this.traceNodeCondition(false, "The capabilities file doesn't allow to convert an index to a level.", trace);
            return false;
        }
        if (!node.getChild(0).isOfCategory(1022)) {
            this.traceNodeCondition(false, "The first argument of the ancestor or descendants function is not a member.", trace);
            return false;
        }
        IXQEQueryNode numericalExpr = node.getChild(1);
        if (numericalExpr.isOfCategory(1023)) {
            this.traceNodeCondition(false, "The second argument of the ancestor or descendants function is a level. No transformation is required.", trace);
            return false;
        }
        AbstractMDXMember member = (AbstractMDXMember)node.getChild(0);
        IHierarchy hierarchy = member.getHierarchy();
        if (node.getType() == 1052 && member.getLevelInfo().getNumProjectedLevels(hierarchy) != 1) {
            this.traceNodeCondition(false, "Within the descendants function, there are more than one levels. Can't convert the distance to a specific level.", trace);
            return false;
        }
        if (!numericalExpr.isOfCategory(1064)) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_NumericalExpressionINAncDecFuncUnsupported, numericalExpr.getNodeTypeName(), node.getNodeTypeName());
        }
        ILevel mdxLevel = member.getLevelInfo().getProjectedLevel(hierarchy, 0);
        MDXNumericConstant mdxConstant = (MDXNumericConstant)node.getChild(1);
        int levelIndex = mdxLevel.getIndex();
        Number temp = (Number)mdxConstant.getConstantValue();
        int distance = temp.intValue();
        int descendantsLevelIndex = distance + levelIndex;
        if (node.getType() == 1052) {
            if (distance < 0 || hierarchy.getLevelCount() <= descendantsLevelIndex) {
                this.traceNodeCondition(false, "Cannot convert the distance parameter in Descendants function to a level.", trace);
                return false;
            }
        } else if (distance < 0 || levelIndex - distance < 0) {
            this.traceNodeCondition(false, "Cannot convert the distance parameter in Ancestor function to a level.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The Ancestor or descendants function has valid number of arguments, expression type and referenced hierarchy.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int distance;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        AbstractMDXMember member = (AbstractMDXMember)node.getChild(0);
        IHierarchy hierarchy = member.getHierarchy();
        MDXLevelInfo levelInfo = member.getLevelInfo();
        ILevel mdxLevel = levelInfo.getProjectedLevel(hierarchy, 0);
        int levelIndex = mdxLevel.getIndex();
        MDXNumericConstant mdxConstant = (MDXNumericConstant)node.getChild(1);
        if (levelInfo.getNumProjectedLevels(hierarchy) == 1) {
            IXQEQueryNode parentLevel = nodeFactory.createNode(1065);
            ((BaseLevel)parentLevel).bind(hierarchy.getLevel(levelIndex - distance));
            if (node.getType() == 1052) {
                ((BaseLevel)parentLevel).bind(hierarchy.getLevel(levelIndex + distance));
            } else {
                ((BaseLevel)parentLevel).bind(hierarchy.getLevel(levelIndex - distance));
            }
            node.exchangeChildNode(node.getChild(1), parentLevel);
        } else if (node.getType() == 1043) {
            member.detach();
            node.exchange(member, false);
            for (distance = ((Number)mdxConstant.getConstantValue()).intValue(); distance > 0; --distance) {
                member.insertParent(nodeFactory.createNode(1046));
            }
        }
    }
}

